<?php
// ++=========================================================================++
// || vBadvanced CMPS v3.2.1 (vB 3.6 - vB 3.8) - 110271
// ||  2003-2009 vBadvanced.com - All Rights Reserved
// || This file may not be redistributed in whole or significant part.
// || http://vbadvanced.com
// || Downloaded 12:18, Sun Jul 26th 2009
// || 350110271_405981043908
// ++ ========================================================================++

error_reporting(E_ALL & ~E_NOTICE);

require_once('./global.php');
require_once(DIR . '/includes/adminfunctions_template.php');
require_once(DIR . '/includes/adminfunctions_language.php');
require_once(DIR . '/includes/vba_cmps_adminfunctions.php');

$scriptname = 'CMPS';
$scriptfile = 'vbacmps_install';

define('PRODUCT_CODE', 'adv_cmps');

define('IS_VB_37', (in_array(substr($vbulletin->options['templateversion'], 0, 3), array(3.7, 3.8))) ? true : false);

print_cp_header('vBadvanced ' . $scriptname . ' Install', '', '<style type="text/css">
<!--
.redalert
{
	background: #FF0000;
	color: #000000;
}
-->
</style>');

if (!in_array(substr($vbulletin->options['templateversion'], 0, 3), array(3.6, 3.7, 3.8)))
{
	echo 'It appears that you are trying to install vBadvanced ' . $scriptname . ' on an older version of vBulletin (3.5 or prior).<br />You must upgrade to vBulletin 3.6.0 or higher before proceeding.';
	exit;
}

if (!is_object($db))
{
	echo 'It appears that you are trying to install the vBulletin 3.6/3.7 version of vBadvanced ' . $scriptname . ' on a vBulletin 3.0 forum.<br />Please go back to <a href="http://www.vbadvanced.com/">vbadvanced.com</a> and download the version for vBulletin 3.0.';
	exit;
}

if (!$_REQUEST['do'])
{
	$_REQUEST['do'] = 'installstart';
}

?>

<script type="text/javascript">
<!--

function safeSubmit(formobj)
{
	if (document.all || document.getElementById)
	{
		for (i = 0; i < formobj.length; i++)
		{
			var tempobj = formobj.elements[i];
			if (tempobj.type == 'submit')
			{
				tempobj.disabled = true;
			}
		}
	}
}
-->
</script>

<?php

// ##################### Delete Template Function #####################
function kill_template($title, $printphrase = 0)
{
	global $db;

	$db->query_write("DELETE FROM " . TABLE_PREFIX . "template WHERE title = '$title'");

	return '<div class="smallfont">Removed template ' . $title . '</div>';
}

// ##### Insert all templates #################################################
function insert_all_templates()
{
	global $maintemplates, $db;

	$db->query_write("DELETE FROM " . TABLE_PREFIX . "template WHERE title IN('" . implode("', '", array_keys($maintemplates)) . "') AND styleid = '-1'");

	$tversions = array(
		'adv_portal' => '3.2.1',
		'adv_portal_dragdrop_headinc' => '3.2.1',
		'adv_portal_module_wrapper' => '3.2.0',
		'adv_portal_newsbits' => '3.1.0',
		'adv_portal_newsbits_attach_thumb' => '3.1.0'
	);

	foreach ($maintemplates AS $name => $content)
	{
		$tempinsert .= "(
			'$name',
			'" . $db->escape_string(compile_template($content)) . "',
			'" . $db->escape_string($content) ."',
			'-1',
			'template',
			" . TIMENOW . ",
			'vBadvanced',
			'" . iif($tversions[$name], $tversions[$name], '3.0.0') . "',
			'" . PRODUCT_CODE . "'
		),";
	}

	$db->query_write("
		INSERT INTO " . TABLE_PREFIX . "template
			(title, template, template_un, styleid, templatetype, dateline, username, version, product)
		VALUES
			" . substr($tempinsert, 0, strlen($tempinsert) - 1)
	);

}

// ##################### Insert Settings Function #####################
function insert_setting()
{
	global $db, $varname, $setting, $grouptitle;

	if (!$varname)
	{
		return false;
	}

	$checksetting = $db->query_first("SELECT varname FROM " . TABLE_PREFIX . "adv_setting WHERE varname = '$varname' AND grouptitle = '$grouptitle'");

	if ($checksetting['varname'])
	{
		return false;
	}

	$db->query_write("
		INSERT INTO " . TABLE_PREFIX . "adv_setting
			(varname, grouptitle, value, defaultvalue, optioncode, displayorder, serialize)
		VALUES (
			'$varname',
			'" . $grouptitle . "',
			'" . $db->escape_string($setting['value']) . "',
			'" . $db->escape_string($setting['value']) . "',
			'" . $db->escape_string($setting['optioncode']) . "',
			" . $setting['displayorder'] . ",
			'$setting[serialize]'
	)");

	$phrasetypeid = 'vbsettings';

	return '<div class="smallfont">Added Setting - ' . $title . '</div>';

}

// ##################### Update Settings Function #####################
function update_setting($phraseonly = false)
{
	global $db, $varname, $setting, $grouptitle;

	if (!$varname)
	{
		return false;
	}

	$oldvarname = $varname;

	$phrasetypeid = 'vbsettings';

	// Title phrase
	update_phrase('setting_' . $varname . '_title', $setting['title']);

	// Description phrase
	update_phrase('setting_' . $varname . '_desc', $setting['description']);

	if ($phraseonly)
	{
		return false;
	}

	$varname = $oldvarname;

	$db->query_write("
		UPDATE " . TABLE_PREFIX . "adv_setting SET
			defaultvalue = '" . $db->escape_string($setting['value']) . "',
			optioncode = '" . $db->escape_string($setting['optioncode']) . "',
			displayorder = $setting[displayorder],
			grouptitle = '$grouptitle',
			serialize = '$setting[serialize]'
		WHERE varname = '$varname' AND grouptitle = '$grouptitle'
	");

	return '<div>Updated Setting - ' . $varname . '</div>';
}

// ##### Rebuild All Settings #################################################
function rebuild_all_settings()
{
	global $db, $vba_modules, $mainsettings, $adv_settinggroups;
	global $grouptitle, $varname, $setting;

	// Need to update the phrases, so we might as well do it here
	// before we start adding duplicates to $mainsettings
	insert_all_phrases();

	// Settinggroups
	foreach ($adv_settinggroups AS $grouptitle => $order)
	{
		$db->query_write("
			INSERT IGNORE INTO " . TABLE_PREFIX . "adv_settinggroup
				(grouptitle, displayorder)
			VALUES (
				'$grouptitle',
				'$order'
		)");
	}

	// Link up the setting grouptitle by filename
	$modfilenames = array();
	foreach ($vba_modules AS $modid => $module)
	{
		if ($module['identifier'])
		{
			if ($module['parent'])
			{
				$module['filename'] .= '-child';
			}

			$modfilenames[$module['filename']] = $module['identifier'];
		}
	}

	$copiedmods = array();
	$extramods = $db->query_read("
		SELECT identifier, filename, parent
		FROM " . TABLE_PREFIX . "adv_modules
		WHERE identifier NOT IN('" . implode("', '", array_values($modfilenames)) . "')
		 AND filename IN('" . implode("', '", array_keys($modfilenames)) . "')
	");
	while ($emod = $db->fetch_array($extramods))
	{
		// Don't mix up the parent and child module's settings
		if ($emod['parent'])
		{
			$emod['filename'] .= '-child';
		}

		// Merge a new grouptitle into the $mainsettings array
		if (isset($modfilenames[$emod['filename']]) AND !empty($mainsettings['adv_portal_' . $modfilenames[$emod['filename']]]))
		{
			$mainsettings['adv_portal_' . $emod['identifier']] = $mainsettings['adv_portal_' . $modfilenames[$emod['filename']]];
		}
	}

	// Got all the settings, now process them
	foreach ($mainsettings AS $grouptitle => $settings)
	{
		$setcount += sizeof($settings);
		$insertsettings = '';
		$csetting = array();
		$getsettings = $db->query_read("
			SELECT varname FROM " . TABLE_PREFIX . "adv_setting
			WHERE grouptitle = '$grouptitle'
				AND varname IN('" . implode("', '", array_keys($settings)) . "')
		");
		while ($set = $db->fetch_array($getsettings))
		{
			$csetting[] = $set['varname'];

			$setting =& $mainsettings[$grouptitle][$set['varname']];

			// Go ahead and update it
			$db->query_write("
				UPDATE " . TABLE_PREFIX . "adv_setting SET
					defaultvalue = '" . $db->escape_string($setting['value']) . "',
					optioncode = '" . $db->escape_string($setting['optioncode']) . "',
					displayorder = $setting[displayorder],
					grouptitle = '$grouptitle',
					serialize = '$setting[serialize]'
				WHERE varname = '$set[varname]' AND grouptitle = '$grouptitle'
			");
		}
		$csetting = array_diff(array_keys($settings), $csetting);

		// New settings
		if (!empty($csetting))
		{
			foreach ($csetting AS $cvarname)
			{
				$setting =& $mainsettings[$grouptitle][$cvarname];

				$insertsettings .= "(
					'$cvarname',
					'" . $grouptitle . "',
					'" . $db->escape_string($setting['value']) . "',
					'" . $db->escape_string($setting['value']) . "',
					'" . $db->escape_string($setting['optioncode']) . "',
					" . $setting['displayorder'] . ",
					'$setting[serialize]'
				),";
			}
		}

		if ($insertsettings)
		{
			$db->query_write("
				INSERT INTO " . TABLE_PREFIX . "adv_setting
					(varname, grouptitle, value, defaultvalue, optioncode, displayorder, serialize)
				VALUES
					" . substr($insertsettings, 0, strlen($insertsettings) - 1)
			);
		}
	}

	build_adv_settings();
}

// ##################### Delete Setting Function #####################
function kill_setting($printphrase = 0)
{
	global $db, $varname, $grouptitle;

	if ($grouptitle == 'adv_global')
	{
		return;
	}

	$db->query_write("DELETE FROM " . TABLE_PREFIX . "adv_setting WHERE varname = '$varname' AND grouptitle = '$grouptitle'");

	kill_phrase('setting_" . $title . "_title');
	kill_phrase('setting_" . $title . "_desc');

	return '<div class="smallfont">Removed Setting - ' . $title . '</div>';
}

// ##### Insert Phrase Function ###############################################
function insert_phrase($forcevarname = '', $forcetext = '')
{
	global $db, $phrasetypeid, $varname, $text, $version;

	if ($forcevarname)
	{
		$varname = $forcevarname;
		$text = $forcetext;
	}

	kill_phrase();

	$db->query_write("
		INSERT INTO " . TABLE_PREFIX . "phrase
			(languageid, varname, text, fieldname, product, username, dateline, version)
		VALUES (
			'-1',
			'" . $varname . "',
			'" . $db->escape_string($text) ."',
			'$phrasetypeid',
			'" . PRODUCT_CODE . "',
			'vBadvanced',
			" . TIMENOW . ",
			'$version'
	)");

	return '<div class="smallfont">Added Phrase - ' . $varname . '</div>';
}

// ##### Update Phrase Function ###############################################
function update_phrase($forcevarname = '', $forcetext = '')
{
	global $db, $varname, $text, $phrasetypeid, $version;

	if ($forcevarname)
	{
		$varname = $forcevarname;
		$text = $forcetext;
	}

	// Insert first, just to make sure it's really there
	$db->query_write("
		INSERT IGNORE INTO " . TABLE_PREFIX . "phrase
			(languageid, varname, text, fieldname, product, username, dateline, version)
		VALUES (
			'-1',
			'" . $varname . "',
			'" . $db->escape_string($text) ."',
			'$phrasetypeid',
			'" . PRODUCT_CODE . "',
			'vBadvanced',
			" . TIMENOW . ",
			'$version'
	)");

	$db->query_write("
		UPDATE " . TABLE_PREFIX . "phrase SET
			text = '" . $db->escape_string($text) ."',
			dateline = " . TIMENOW . ",
			version = '$version',
			username = 'vBadvanced'
		WHERE varname = '$varname'
			AND fieldname = '$phrasetypeid'
			AND product = '" . PRODUCT_CODE . "'
			AND languageid = '-1'
	");

	return '<div class="smallfont">Updated Phrase - ' . $varname . '</div>';
}

// ##################### Delete Phrase Function #####################
function kill_phrase($forcevarname = '')
{
	global $db, $varname, $phrasetypeid;

	if ($forcevarname)
	{
		$varname = $forcevarname;
	}

	$db->query_write("
		DELETE FROM " . TABLE_PREFIX . "phrase
		WHERE varname = '$varname'
			AND fieldname = '$phrasetypeid'
			AND product = '" . PRODUCT_CODE . "'
			AND languageid = '-1'
	");

	return '<div class="smallfont">Removed phrase ' . $varname . '</div>';
}

// ##### Complete Phrase Insert/Delete ########################################
function insert_all_phrases()
{
	global $db, $mainphrases, $mainsettings, $version;

	// Settings phrases
	foreach ($mainsettings AS $grouptitle => $settings)
	{
		foreach ($settings AS $varname => $setting)
		{
			$mainphrases['vbsettings']['setting_' . $varname . '_title'] = $setting['title'];
			$mainphrases['vbsettings']['setting_' . $varname . '_desc'] = $setting['description'];
		}
	}

	// Main phrases
	foreach ($mainphrases AS $fieldname => $phrases)
	{
		$db->query_write("
			DELETE FROM " . TABLE_PREFIX . "phrase
			WHERE fieldname = '$fieldname'
				AND varname IN('" . implode("','", array_keys($phrases)) . "')
				AND languageid = '-1'
		");

		$insertquery = '';
		foreach ($phrases AS $varname => $text)
		{
			$insertquery .= "('-1', '$varname', '" . $db->escape_string($text) . "', '$fieldname', '" . PRODUCT_CODE . "', 'vBadvanced', " . TIMENOW . ", '$version'),";
		}

		$db->query_write("
			INSERT INTO " . TABLE_PREFIX . "phrase
				(languageid, varname, text, fieldname, product, username, dateline, version)
			VALUES
				" . substr($insertquery, 0, strlen($insertquery) - 1)
		);
	}

	build_language(-1);

}

// ##### Print Form Header w/ js to disable button ############################
function print_js_form_header($file, $do)
{
	echo '<form action="' . $file . '.php" method="post" onsubmit="return safeSubmit(this)">
		<input type="hidden" name="adminhash" value="' . ADMINHASH . '" />';

	if ($do)
	{
		echo '<input type="hidden" name="do" value="' . $do . '" />';
	}

	print_table_start();
}

// ##### Install Table Start Function #########################################
function print_install_table_start($title = '', $reqdo = '')
{
	global $scriptfile, $scriptname;

	print_js_form_header($scriptfile, $reqdo);

	if (!$title)
	{
		$title = 'vBadvanced ' . $scriptname . ' Install';
	}

	print_table_header($title);
}

// ##### Install End Table Function ###########################################
function print_install_table_end()
{
	global $stepphrase, $scriptname, $step, $nextstep, $nextdo, $rebuildtemp, $nocontinue, $forumsoff;

	print_description_row('<div style="padding:12px;">' . $stepphrase . '</div>');

	if ($_REQUEST['do'] == 'installstart')
	{
		print_description_row('Main Options', false, 2, 'thead');
		print_radio_row('', 'do', array(
				'install' => 'Begin the installation process.',
				'upgrade' => 'Upgrade.',
				'uninstall' => 'Uninstall vBadvanced ' . $scriptname . '.'
			), 'install');

		print_description_row('Maintenance', false, 2, 'thead');
		print_radio_row('', 'do', array(
				'templates' => 'Reinstall the templates.',
				'phrases' => 'Reinstall the phrases.',
				'rebuildsettings' => 'Rebuild the settings',
				'updateplugins' => 'Reinstall the vBulletin plugins.',
				'doimages' => 'Update your image paths.'
			));

	}

	construct_hidden_code('step', iif($nextstep, $nextstep, $step + 1));

	if ($nextdo != 'closeforums')
	{
		construct_hidden_code('forumsoff', $forumsoff);
	}

	if ($nextdo)
	{
		construct_hidden_code('do', $nextdo);
	}

	print_table_break();

	if ($rebuildtemp)
	{
		build_all_styles(0, 0);
	}

	if ($nocontinue)
	{
		print_table_footer();
	}
	else
	{
		print_submit_row('Continue', '');
	}
}

// ##### Check for and add indexes ############################################
function add_table_index($table, $column)
{
	global $db;
	$indexcheck = $db->query("SHOW KEYS FROM " . TABLE_PREFIX . $table);
	while ($icheck = $db->fetch_array($indexcheck))
	{
		if ($icheck['Column_name'] == $column AND $icheck['Seq_in_index'] == 1)
		{
			return;
		}
	}
	$db->query_write("ALTER TABLE " . TABLE_PREFIX . "$table ADD INDEX ($column)");
}

// ##### Insert Plugins #######################################################
function insert_plugins()
{
	global $db, $vba_plugins;

	$plugcheck = array();
	$getplugins = $db->query_read("
		SELECT devkey
		FROM " . TABLE_PREFIX . "plugin
		WHERE devkey IN('" . implode("', '", array_keys($vba_plugins)) . "')
	");
	while ($plugin = $db->fetch_array($getplugins))
	{
		$plugcheck[$plugin['devkey']] = true;
	}

	foreach ($vba_plugins AS $devkey => $plugin)
	{
		$plugin['devkey'] = $devkey;

		if (!$plugin['product'])
		{
			$plugin['product'] = PRODUCT_CODE;
		}
		$plugin['active'] = 1;

		// Setting this to 3 should prevent problems with vBSEO?
		// adv_cmps_init_startup plugin needs to be executed after adv_cmps_integrate_start

		switch ($devkey)
		{
			case 'adv_cmps_integrate_start':
				$plugin['executionorder'] = 1;
			break;

			case 'adv_cmps_init_startup':
				$plugin['executionorder'] = 2;
			break;
			
			default:
				$plugin['executionorder'] = 3;
		}

		$db->query_write(fetch_query_sql($plugin, 'plugin', iif($plugcheck[$devkey], "WHERE devkey = '$devkey'", '')));
	}

	vBulletinHook::build_datastore($db);
}

// ############################################################################
// Arrays
// ############################################################################

// ##### Templates ############################################################
$maintemplates = array(
'adv_portal' =>
'$stylevar[htmldoctype]
<html dir="$stylevar[textdirection]" lang="$stylevar[languagecode]" xmlns="http://www.w3.org/1999/xhtml">
<head>
<if condition="$pages[\'name\'] == \'home\'">
	<meta http-equiv="Cache-Control" content="no-cache" />
	<meta http-equiv="Pragma" content="no-cache" />
	<meta http-equiv="Expires" content="0" />
</if>

<title>$vboptions[hometitle] <if condition="$pagetitle">- $pagetitle</if></title>

$headinclude

</head>
<body>

$header

$navbar

<if condition="$show[\'customizepagelink\']">
	<div align="$stylevar[right]" style="padding-top: $stylevar[cellpadding]px; padding-bottom: $stylevar[cellpadding]px">
		<if condition="$show[\'customizepage\']">
			[<a href="javascript: reset_cmps_layout($pages[pageid])">$vbphrase[reset_layout]</a>] 
			[<a href="$show[customizepagelink]">$vbphrase[exit_customization_mode]</a>]
		<else />
			[<a href="$show[customizepagelink]">$vbphrase[customize_this_page]</a>]
		</if>
	</div>
</if>

<table align="center" class="page" cellspacing="0" cellpadding="0" width="100%">
	<tr valign="top">
		<if condition="$show[\'left_column\']">
			<td width="$vba_style[portal_leftcolwidth]"<if condition="$show[\'center_column\'] OR $show[\'right_column\']"> style="padding-$stylevar[right]: $vba_style[portal_colspacing]px"</if>>
				$home[leftblocks]
			</td>
		</if>
		<if condition="$show[\'center_column\']">
			<td valign="top">
				$home[centerblocks]
			</td>
		</if>
		<if condition="$show[\'right_column\']">
			<td valign="top" width="$vba_style[portal_rightcolwidth]"<if condition="$show[\'center_column\'] OR $show[\'left_column\']"> style="padding-$stylevar[left]: $vba_style[portal_colspacing]px"</if>>
				$home[rightblocks]
			</td>
		</if>
	</tr>
</table>

$footer

</body>
</html>',


'adv_portal_archivebits_exp' =>
'<tr>
	<if condition="$mod_options[\'portal_archive_showicon\']">
		<td class="alt2">
			<if condition="$show[\'threadicon\']">
				<img alt="" border="0" src="$news[threadiconpath]" title="$news[threadicontitle]" />
			</if>
		</td>
	</if>

	<td class="alt1" align="$stylevar[left]">
		<if condition="$news[\'subscribed\'] OR $show[\'paperclip\'] OR ($news[\'sticky\'] AND $mod_options[\'portal_archive_stickyicon\'])">
		<span style="float:$stylevar[right]">
			<if condition="$news[\'subscribed\']">
				<img alt="" class="inlineimg" src="$stylevar[imgdir_misc]/subscribed.gif" title="$vbphrase[you_are_subscribed_to_this_thread]" />
			</if>
			<if condition="$show[\'paperclip\']">
				<a href="#" onclick="vba_attach_win($news[threadid]); return false"><img class="inlineimg" src="$stylevar[imgdir_misc]/paperclip.gif" border="0" title="<phrase 1="$news[attach]">$vbphrase[x_attachments]</phrase>" alt="" /></a>
			</if>
			<if condition="$news[\'sticky\'] AND $mod_options[\'portal_archive_stickyicon\']">
				<img class="inlineimg" src="$stylevar[imgdir_misc]/sticky.gif" title="$vbphrase[sticky_thread]" alt="" />
			</if>
		</span>
		</if>
		<a href="$vboptions[bburl]/showthread.php?$session[sessionurl]t=$news[threadid]" title="$news[preview]">$news[title]</a>
		<if condition="$mod_options[\'portal_archive_multipage\'] AND $show[\'pagenav\']">
			<span class="smallfont">(<img class="inlineimg" src="$stylevar[imgdir_misc]/multipage.gif" border="0" alt="" /> $news[pagenav]<if condition="$show[pagenavmore]">... <a href="$vboptions[bburl]/showthread.php?$session[sessionurl]t=$news[threadid]&amp;page=$news[totalpages]">$vbphrase[last_page]</a></if>)</span>
		</if>
		<if condition="$news[\'rating\'] AND $mod_options[\'portal_archive_showrating\']">
			<span style="float:$stylevar[right]"><img alt="" src="$stylevar[imgdir_rating]/rating_$news[rating].gif" title="<phrase 1="$news[votenum]" 2="$news[voteavg]">$vbphrase[thread_rating_x_votes_y_average]</phrase>" /></span>
		</if>
		<if condition="$mod_options[\'portal_archive_threadstarter\']">
 			<div class="smallfont">
				<phrase 1="$vboptions[bburl]/member.php?$session[sessionurl]u=$news[postuserid]" 2="$news[postusername]">$vbphrase[by_x]</phrase>
			</div>
		</if>
		<if condition="$mod_options[\'portal_archive_showdate\']">
			<div class="smallfont">$news[postdate] <span class="time">$news[posttime]</span></div>
		</if>
	</td>

	<if condition="$show[\'lastpost\']">
		<td class="alt2">
			<div class="smallfont" style="text-align:$stylevar[right]; white-space:nowrap">
				$news[lastpostdate] <span class="time">$news[lastposttime]</span><br />
				<phrase 1="$vboptions[bburl]/member.php?$session[sessionurl]find=lastposter&amp;t=$news[threadid]" 2="$news[lastposter]">$vbphrase[by_x]</phrase> <a href="$vboptions[bburl]/showthread.php?$session[sessionurl]p=$news[lastpostid]#post$news[lastpostid]"><img alt="" border="0" src="$stylevar[imgdir_button]/lastpost.gif" title="$vbphrase[go_to_last_post]" /></a>
			</div>
		</td>
	</if>

	<if condition="$mod_options[\'portal_archive_showreplies\']">
		<td align="center" class="$class_reply"><span class="smallfont">$news[replycount]</span></td>
	</if>
	<if condition="$mod_options[\'portal_archive_showviews\']">
		<td align="center" class="$class_view"><span class="smallfont">$news[views]</span></td>
	</if>
	<if condition="$mod_options[\'portal_newsarchive_showforum\']">
		<td class="$class_ftitle">
			<span class="smallfont"><a href="$vboptions[bburl]/forumdisplay.php?$session[sessionurl]f=$news[forumid]">$news[forumtitle]</a></span>
		</td>
	</if>
</tr>',


'adv_portal_archivebits_exp_head' =>
'<tr>
	<if condition="$mod_options[\'portal_archive_showicon\']">
		<td class="thead" width="15">&nbsp;</td>
	</if>
	<td class="thead" width="100%">$vbphrase[title_username_date]</td>
	<if condition="$show[\'lastpost\']">
		<td align="center" class="thead" style="white-space: nowrap" width="25%">$vbphrase[last_post]</td>
	</if>
	<if condition="$mod_options[\'portal_archive_showreplies\']">
		<td class="thead" width="15">$vbphrase[replies]</td>
	</if>
	<if condition="$mod_options[\'portal_archive_showviews\']">
		<td class="thead" width="15">$vbphrase[views]</td>
	</if>
	<if condition="$mod_options[\'portal_newsarchive_showforum\']">
		<td align="center" class="thead" width="10%">$vbphrase[forum]</td>
	</if>
</tr>',


'adv_portal_archivebits_lean' =>
'<tr>
	<td class="$bgclass">
		<if condition="$show[\'paperclip\'] OR ($news[\'sticky\'] AND $mod_options[\'portal_archive_stickyicon\'])">
			<span style="float:$stylevar[right]">
				<if condition="$show[\'paperclip\']">
					<a href="#" onclick="vba_attach_win($news[threadid]); return false"><img class="inlineimg" src="$stylevar[imgdir_misc]/paperclip.gif" border="0" title="<phrase 1="$news[attach]">$vbphrase[x_attachments]</phrase>" alt="" /></a>
				</if>
				<if condition="$news[\'sticky\'] AND $mod_options[\'portal_archive_stickyicon\']">
					<img class="inlineimg" src="$stylevar[imgdir_misc]/sticky.gif" title="$vbphrase[sticky_thread]" alt="" />
				</if>
			</span>
		</if>
		<if condition="$news[threadiconpath] AND $mod_options[\'portal_archive_showicon\']">
			<img alt="" class="inlineimg" src="$news[threadiconpath]" border="0" title="$news[threadicontitle]" />
		</if>
		<if condition="$news[\'subscribed\'] AND $mod_options[\'portal_archive_showsubscribed\']">
			<img alt="" class="inlineimg" src="$stylevar[imgdir_misc]/subscribed.gif" title="$vbphrase[you_are_subscribed_to_this_thread]" />
		</if>
		<if condition="$news[\'rating\'] AND $mod_options[\'portal_archive_showrating\']">
			<span style="float:$stylevar[right]"><img alt="" src="$stylevar[imgdir_rating]/rating_$news[rating].gif" title="<phrase 1="$news[votenum]" 2="$news[voteavg]">$vbphrase[thread_rating_x_votes_y_average]</phrase>" /></span>
		</if>
		<span class="smallfont"><a href="$vboptions[bburl]/showthread.php?$session[sessionurl]t=$news[threadid]" title="$news[preview]">$news[title]</a></span>
		<if condition="$mod_options[\'portal_archive_multipage\'] AND $show[\'pagenav\']">
			<span class="smallfont">(<img class="inlineimg" src="$stylevar[imgdir_misc]/multipage.gif" border="0" alt="" /> $news[pagenav]<if condition="$show[pagenavmore]">... <a href="$vboptions[bburl]/showthread.php?$session[sessionurl]t=$news[threadid]&amp;page=$news[totalpages]">$vbphrase[last_page]</a></if>)</span>
		</if>
		<if condition="$mod_options[\'portal_archive_showdate\']">
			<div class="smallfont">$news[postdate] <span class="time">$news[posttime]</span></div>
		</if>
		<if condition="$mod_options[\'portal_archive_threadstarter\']">
 			<div class="smallfont">
				<phrase 1="$vboptions[bburl]/member.php?$session[sessionurl]u=$news[postuserid]" 2="$news[postusername]">$vbphrase[by_x]</phrase>
			</div>
		</if>
		<if condition="$mod_options[\'portal_newsarchive_showforum\']">
			<div class="smallfont" style="padding-top:$stylevar[cellpadding]px"><a href="$vboptions[bburl]/forumdisplay.php?$session[sessionurl]f=$news[forumid]">$news[forumtitle]</a></div>
		</if>
		<if condition="$show[\'lastpost\']">
			<div class="smallfont" style="padding-top:$stylevar[cellpadding]px">
				<a href="$vboptions[bburl]/showthread.php?$session[sessionurl]p=$news[lastpostid]#post$news[lastpostid]"><img class="inlineimg" alt="" border="0" src="$stylevar[imgdir_button]/lastpost.gif" title="$vbphrase[go_to_last_post]" /></a> $vbphrase[last_post_by] <a href="$vboptions[bburl]/member.php?$session[sessionurl]find=lastposter&amp;t=$news[threadid]">$news[lastposter]</a>
			</div>
			<div class="smallfont">$news[lastpostdate] <span class="time">$news[lastposttime]</span></div>
		</if>
		<if condition="$mod_options[\'portal_archive_showreplies\'] OR $mod_options[\'portal_archive_showviews\']">
			<div class="smallfont" style="padding-top:$stylevar[cellpadding]px">
				<if condition="$mod_options[\'portal_archive_showreplies\']">$news[replycount] $vbphrase[replies]</if>$archive_rep_view_comma
				<if condition="$mod_options[\'portal_archive_showviews\']">$news[views] $vbphrase[views]</if>
			</div>
		</if>
	</td>
</tr>',


'adv_portal_buddylistbits' =>
'<div class="smallfont" style="padding-bottom:2px">
	<span style="float:$stylevar[right]">
	<a href="$vboptions[bburl]/private.php?$session[sessionurl]do=newpm&amp;u=$loggedin[userid]" title="<phrase 1="$loggedin[username]">$vbphrase[send_private_message_to_x]</phrase>">$vbphrase[pm]</a>
	<a href="$vboptions[bburl]/profile.php?$session[sessionurl]do=removelist&amp;userlist=buddy&amp;u=$loggedin[userid]" title="$vbphrase[remove_from_buddy_list]">X</a>
	</span>
	<a href="$vboptions[bburl]/member.php?$session[sessionurl]u=$loggedin[userid]">$loggedin[username]</a> $loggedin[invisiblemark]
</div>',


'adv_portal_calendar_day' =>
'<td class="<if condition="$show[\'highlightweek\']">alt1<else />alt2</if>"<if condition="$show[\'highlighttoday\']"> style="border:solid 1px red; font-weight:bold" title="$vbphrase[today]"</if>>
	<span class="smallfont">
		<if condition="$show[\'daylink\']">
			<a href="$vboptions[bburl]/calendar.php?$session[sessionurl]do=getinfo&amp;day=$year-$month-$day&amp;c=$calendarid" title="$eventdesc">$day</a>
		<else />
			$day
		</if>
	</span>
</td>',


'adv_portal_calendar_day_other' =>
'<td class="alt1"><span class="smallfont">$day</span></td>',


'adv_portal_calendar_header' =>
'<tr>
	<if condition="$show[\'day1\']"><td align="center" class="thead">$day1</td></if>
	<if condition="$show[\'day2\']"><td align="center" class="thead">$day2</td></if>
	<if condition="$show[\'day3\']"><td align="center" class="thead">$day3</td></if>
	<if condition="$show[\'day4\']"><td align="center" class="thead">$day4</td></if>
	<if condition="$show[\'day5\']"><td align="center" class="thead">$day5</td></if>
	<if condition="$show[\'day6\']"><td align="center" class="thead">$day6</td></if>
	<if condition="$show[\'day7\']"><td align="center" class="thead">$day7</td></if>
</tr>
$calendarrowbits
',


'adv_portal_calendar_week' =>
'<tr align="center">
	$calendardaybits
</tr>
',


'adv_portal_dragdrop_headinc' =>
'<script type="text/javascript" src="<if condition="IS_VB_38">$stylevar[yuipath]<else />http://yui.yahooapis.com/2.7.0/build</if>/animation/animation-min.js"></script>
<script type="text/javascript" src="<if condition="IS_VB_38">$stylevar[yuipath]<else />http://yui.yahooapis.com/2.7.0/build</if>/dragdrop/dragdrop-min.js"></script>
<script type="text/javascript" src="$vboptions[bburl]/clientscript/vba_cmps_dd.js"></script>
<style type="text/css">
<!--
ul.draglist {
	border: 1px dashed gray;
	margin: 10px 0 10px 0;
	min-width: 40px;
	padding: 15px 5px 15px 5px;
	list-style: none;
	position: relative;
}

ul.draglist li {
	margin: 2px;
	cursor: move;
}

-->
</style>',


'adv_portal_footer' =>
'<!-- Do NOT remove this copyright notice. Doing so is a violation of your user agreement! -->

<div align="center" class="smallfont"><phrase 1="$vba_options[portal_version]">$vbphrase[powered_by_vbadvanced_cmps]</phrase></div>',


'adv_portal_moderation' =>
'<tr>
	<td class="$bgclass">
		<if condition="$show[\'threads\']">
			<div<if condition="$moditems[thread]"> style="font-weight: bold"</if>><a href="$vboptions[bburl]/moderation.php?$session[sessionurl]do=viewthreads&amp;type=moderated">$vbphrase[threads]</a> ($moditems[thread])</div>
		</if>
		<if condition="$show[\'posts\']">
			<div<if condition="$moditems[reply]"> style="font-weight: bold"</if>><a href="$vboptions[bburl]/moderation.php?$session[sessionurl]do=viewposts&amp;type=moderated">$vbphrase[posts]</a> ($moditems[reply])</div>
		</if>

		<if condition="$show[\'visitormessage\']">
			<div<if condition="$moditems[visitormessage]"> style="font-weight: bold"</if>><a href="$vboptions[bburl]/moderation.php?$session[sessionurl]do=viewvms&amp;type=moderated">$vbphrase[visitor_messages]</a> ($moditems[visitormessage])</div>
		</if>

		<if condition="$show[\'events\']">
			<div<if condition="$events[count]"> style="font-weight: bold"</if>><a href="$modcpdir/moderate.php?$session[sessionurl]do=events" target="_blank">$vbphrase[events]</a> ($events[count])</div>
		</if>
		<if condition="$show[\'attachments\']">
			<div<if condition="$attachments[count]"> style="font-weight: bold"</if>><a href="$modcpdir/moderate.php?$session[sessionurl]do=attachments" target="_blank">$vbphrase[attachments]</a> ($attachments[count])</div>
		</if>
		<div<if condition="$users[count]"> style="font-weight: bold"</if>><a href="$admincpdir/user.php?$session[sessionurl]do=moderate" target="_blank">$vbphrase[members]</a> ($users[count])</div>

		$template_hook[adv_portal_moderation]

	</td>
</tr>',


'adv_portal_module_wrapper' =>
'$mods[formcode]

<div style="padding-bottom:$vba_style[portal_vspace]px">
	<table align="center" border="0" cellpadding="$stylevar[cellpadding]" cellspacing="$stylevar[cellspacing]" class="tborder" width="100%">
		<thead>
			<tr>
				<td class="tcat" colspan="$mods[colspan]">
				<if condition="$vba_style[\'portal_collapsemods\']">
					<a href="#top" onclick="return toggle_collapse(\'module_$mods[collapse]\')" style="float:$stylevar[right]"><img alt="" border="0" id="collapseimg_module_$mods[collapse]" src="$stylevar[imgdir_button]/collapse_tcat$modimgcollapse.gif" /></a>
				</if>
				<span class="smallfont"><strong>$vba_style[portal_blockbullet] <if condition="$mods[\'link\']"><a href="$mods[link]">$mods[title]</a><else />$mods[title]</if></strong></span></td>
			</tr>
		</thead>
		<tbody id="collapseobj_module_$mods[collapse]" style="$modcollapse">
			<if condition="$show[\'tablerow\']">
				<tr>
					<td class="$bgclass">
						$modulehtml
					</td>
				</tr>
			<else />
				$modulehtml
			</if>
		</tbody>
	</table>
</div>
<if condition="$show[\'endform\']"></form></if>',


'adv_portal_navigation' =>
'<tr>
	<td class="$bgclass">
		$navigationbits
		$customnavigationbits
	</td>
</tr>',


'adv_portal_navigationbits' =>
'<div class="smallfont">$navmark <if condition="$link"><a href="$link">$title</a><else />$title</if></div>',


'adv_portal_newsbits' =>
'<if condition="!$mod_options[\'portal_news_legacy\']">
	<tr>
		<td class="thead"><if condition="$mod_options[\'portal_news_showicon\']">$vba_style[portal_blockbullet]</if> $news[prefix] <a href="$vboptions[bburl]/showthread.php?$session[sessionurl]t=$news[threadid]">$news[title]</a></td>
	</tr>
</if>
<tr>
	<td class="<if condition="$mod_options[\'portal_news_legacy\']">thead<else />alt2</if>">
		<if condition="($mod_options[\'portal_news_showrating\'] AND $news[\'rating\']) OR ($news[\'subscribed\'] AND $mod_options[\'portal_news_showsubscribed\'])">
			<span style="float:$stylevar[right]">
				<if condition="$mod_options[\'portal_news_showrating\'] AND $news[\'rating\']">
					<img alt="" src="$stylevar[imgdir_rating]/rating_$news[rating].gif" title="<phrase 1="$news[votenum]" 2="$news[voteavg]">$vbphrase[thread_rating_x_votes_y_average]</phrase>" />
				</if>

				<if condition="$news[\'subscribed\'] AND $mod_options[\'portal_news_showsubscribed\']">
					<img alt="" class="inlineimg" src="$stylevar[imgdir_misc]/subscribed.gif" title="$vbphrase[you_are_subscribed_to_this_thread]" />
				</if>
			</span>
		</if>
		$news[dateposted] - <phrase 1="$vboptions[bburl]/member.php?$session[sessionurl]u=$news[postuserid]" 2="$news[postusername]">$vbphrase[by_x]</phrase>
	</td>
</tr>
<tr>
	<td align="$stylevar[left]" class="alt1" valign="top">
		<if condition="$show[\'paperclip\']">
			<span style="float:$stylevar[right]">
				<a href="#" onclick="vba_attach_win($news[threadid]); return false"><img class="inlineimg" src="$stylevar[imgdir_misc]/paperclip.gif" border="0" title="<phrase 1="$news[attach]">$vbphrase[x_attachments]</phrase>" alt="" /></a>
			</span>
		</if>
		<if condition="$news[\'avatarpath\']">
			<img align="$stylevar[left]" style="padding:6px" alt="<phrase 1="$news[postusername]">$vbphrase[xs_avatar]</phrase>" border="0" src="$news[avatarpath]" />
		</if>
		$news[message]

		<if condition="$show[\'signature\']">
		<div>__________________<br />
		$news[signature]</div>
		</if>

		</td>
	</tr>

	<if condition="$news[\'attachment\']">
		<tr class="alt1">
			<td>
				<fieldset class="fieldset">
				<legend>Attached Files</legend>
				<div style="padding:$stylevar[formspacer]px">
					$news[attachment]
				</div>
				</fieldset>
			</td>
		</tr>
	</if>

	<tr class="alt2" valign="middle">
	<td valign="middle">
		<span style="float:right">
		<if condition="$show[\'editbutton\']">
			<a href="$vboptions[bburl]/editpost.php?$session[sessionurl]do=editpost&amp;p=$news[postid]"><img alt="$vbphrase[edit_this_post]" border="0" src="$stylevar[imgdir_button]/edit.gif" /></a>
		</if>

		<if condition="$show[\'replybutton\']">
			<a href="$vboptions[bburl]/newreply.php?$session[sessionurl]do=newreply&amp;t=$news[threadid]"><img alt="$vbphrase[reply_to_this_post]" border="0" src="$stylevar[imgdir_button]/reply_small.gif" /></a>
		</if>

		<if condition="$mod_options[\'portal_news_showsendfriend\']">
			<a href="$vboptions[bburl]/sendmessage.php?$session[sessionurl]do=sendtofriend&amp;t=$news[threadid]"><img alt="" border="0" src="$stylevar[imgdir_button]/sendtofriend.gif" title="$vbphrase[send_to_friend]" /></a>
		</if>

		<if condition="$mod_options[\'portal_news_showprintable\']">
			<a href="$vboptions[bburl]/printthread.php?$session[sessionurl]t=$news[threadid]"><img alt="" border="0" src="$stylevar[imgdir_button]/printer.gif" title="$vbphrase[show_printable_version]" /></a>
		</if>
		</span>

		<span class="smallfont">
		<if condition="$mod_options[\'portal_news_allowreplies\']">$news[replycount] <if condition="$news[\'reply_noformat\'] == 1">$vbphrase[reply]<else />$vbphrase[replies]</if></if><if condition="$mod_options[\'portal_news_showviews\'] AND $mod_options[\'portal_news_allowreplies\']"> | </if><if condition="$mod_options[\'portal_news_showviews\']">$news[views] $vbphrase[views]</if></span>
	</td>
</tr>',


'adv_portal_newsbits_attach_inline' =>
'<div>
	<img class="inlineimg" src="$stylevar[imgdir_attach]/$attachment[attachmentextension].gif" alt="<phrase 1="$attachment[attachmentextension]">$vbphrase[file_type_x]</phrase>" width="16" height="16" border="0" style="vertical-align:baseline" /> <a href="$vboptions[bburl]/attachment.php?$session[sessionurl]attachmentid=$attachment[attachmentid]">$attachment[filename]</a>
	($attachment[filesize], <phrase 1="$attachment[counter]">$vbphrase[x_views]</phrase>)
</div>',


'adv_portal_newsbits_attach_thumb' =>
'<a href="$vboptions[bburl]/attachment.php?$session[sessionurl]attachmentid=$attachment[attachmentid]&amp;d=$attachment[dateline]" rel="Lightbox$lightboxid" id="attachment$attachment[attachmentid]"<if condition="$show[\'newwindow\']"> target="_blank"</if>><img src="$vboptions[bburl]/attachment.php?$session[sessionurl]attachmentid=$attachment[attachmentid]&amp;stc=1&amp;thumb=1&amp;d=$attachment[thumbnail_dateline]" class="thumbnail" border="0" alt="<phrase 1="$attachment[filename]" 2="$attachment[counter]" 3="$attachment[filesize]" 4="$attachment[attachmentid]">$vbphrase[image_larger_version_x_y_z]</phrase>" /></a> &nbsp;',


'adv_portal_onlineusers' =>
'<tr>
<td class="thead"><span class="smallfont"><phrase 1="$numberregistered" 2="$numberguest">$vbphrase[x_members_and_y_guests]</phrase></span></td>
	</tr>
	<tr>
		<td class="$altbgclass"><span class="smallfont">$activeusers</span></td>
	</tr>

	<tr>
		<td class="$bgclass"><span class="smallfont"><phrase 1="$recordusers" 2="$recorddate" 3="$recordtime">$vbphrase[most_users_ever_online_was_x_y_at_z]</phrase></span></td>
</tr>',


'adv_portal_poll' =>
'<tr>
	<td class="thead">$pollmod[question]</td>
</tr>

$pollbits

<tr>
	<td align="$stylevar[left]" class="$altbgclass">
		<if condition="$pollmod[\'showresults\']">
			<span class="smallfont"><strong>$vbphrase[total_votes]: $pollmod[nvotes]</strong><br />$pollmod[message].</span>
		<else />
			<input type="hidden" name="s" value="$session[dbsessionhash]" />
			<input type="hidden" name="do" value="pollvote" />
			<input type="hidden" name="pollid" value="$pollmod[pollid]" />
			<input type="submit" class="button" value="$vbphrase[vote_now]" />
			<if condition="$pollmod[\'public\'] AND $bbuserinfo[\'userid\']">
				<div class="smallfont">$vbphrase[public_poll_users_see_choices]</div>
			</if>
		</if>
	</td>
</tr>
<tr>
	<td class="$bgclass">
		<div class="smallfont">&raquo; <a href="$vboptions[bburl]/poll.php?$session[sessionurl]do=showresults&amp;pollid=$pollmod[pollid]">$vbphrase[view_poll_results]</a>
		<if condition="$mod_options[\'portal_poll_allowreplies\']">
			<br />&raquo; <a href="$vboptions[bburl]/newreply.php?$session[sessionurl]t=$pollmod[threadid]">$vbphrase[comment_on_this_poll]</a>
			<br />&raquo; <a href="$vboptions[bburl]/showthread.php?$session[sessionurl]t=$pollmod[threadid]">$vbphrase[this_poll_has] $pollmod[replycount] <if condition="$pollmod[\'replycount\'] == 1">$vbphrase[reply]<else />$vbphrase[replies]</if></a>
		</if>
		<if condition="$show[\'editpoll\']">
			<br />&raquo; <a href="$vboptions[bburl]/poll.php?$session[sessionurl]do=polledit&amp;pollid=$pollmod[pollid]">$vbphrase[edit_poll]</a>
		</if>
		</div>
	</td>
</tr>',


'adv_portal_polloption' =>
'<tr>
	<td class="$bgclass" valign="middle">
		<input id="pollchoice_$mods[modid]_$option[number]" name="optionnumber" type="radio" value="$option[number]" />
		<span class="smallfont"><label for="pollchoice_$mods[modid]_$option[number]">$option[question]</label></span>
	</td>
</tr>',


'adv_portal_polloption_multiple' =>
'<tr>
	<td class="$bgclass">
		<input id="pollchoice_$mods[modid]_$option[number]" name="optionnumber[$option[number]]" type="checkbox" value="yes" />
		<span class="smallfont"><label for="pollchoice_$mods[modid]_$option[number]">$option[question]</label></span>
	</td>
</tr>',


'adv_portal_pollresult' =>
'<tr>
	<td class="$bgclass">
		<div class="smallfont"><if condition="$show[\'voteital\']"><em>$option[question] - $option[percent]%</em><else />$option[question] - $option[percent]%</if></div>
		<img title="$option[votes] $votephrase" alt="" height="10" src="$stylevar[imgdir_poll]/bar$option[graphicnumber]-l.gif" width="3" /><img title="$option[votes] $votephrase" alt="$option[votes] $votephrase" height="10" src="$stylevar[imgdir_poll]/bar$option[graphicnumber].gif" width="$option[barnumber]" /><img title="$option[votes] $votephrase" alt="" height="10" src="$stylevar[imgdir_poll]/bar$option[graphicnumber]-r.gif" width="3" />
	</td>
</tr>',


'adv_portal_recthreads_exp' =>
'<tr>
	<if condition="$mod_options[\'portal_threads_showicon\']">
		<td class="alt2"><if condition="$show[\'threadicon\']"><img alt="" border="0" src="$thread[threadiconpath]" title="$thread[threadicontitle]" /></if></td>
	</if>

	<td class="alt1">
		<if condition="$thread[\'subscribed\'] OR $show[\'paperclip\'] OR ($thread[\'sticky\'] AND $mod_options[\'portal_threads_stickyicon\'])">
		<span style="float:$stylevar[right]">
			<if condition="$thread[\'subscribed\']">
				<img alt="" class="inlineimg" src="$stylevar[imgdir_misc]/subscribed.gif" title="$vbphrase[you_are_subscribed_to_this_thread]" />
			</if>
			<if condition="$show[\'paperclip\']">
				<a href="#" onclick="vba_attach_win($thread[threadid]); return false"><img class="inlineimg" src="$stylevar[imgdir_misc]/paperclip.gif" border="0" title="<phrase 1="$thread[attach]">$vbphrase[x_attachments]</phrase>" alt="" /></a>
			</if>
			<if condition="$thread[\'sticky\'] AND $mod_options[\'portal_threads_stickyicon\']">
				<img class="inlineimg" src="$stylevar[imgdir_misc]/sticky.gif" title="$vbphrase[sticky_thread]" alt="" />
			</if>
		</span>
		</if>
		<if condition="$mod_options[\'portal_threads_newpostarrow\'] AND $show[\'gotonewpost\']">
			<a href="$vboptions[bburl]/showthread.php?$session[sessionurl]t=$thread[threadid]&amp;goto=newpost"><img alt="$vbphrase[go_to_first_new_post]" src="$stylevar[imgdir_button]/firstnew.gif" border="0" class="inlineimg" /></a>
		</if>
		$thread[prefix]
		<a href="$vboptions[bburl]/showthread.php?$session[sessionurl]t=$thread[threadid]" title="$thread[preview]"><if condition="$show[\'gotonewpost\']"><strong>$thread[title]</strong><else />$thread[title]</if></a>
		<if condition="$mod_options[\'portal_threads_multipage\'] AND $show[\'pagenav\']">
			<span class="smallfont">(<img class="inlineimg" src="$stylevar[imgdir_misc]/multipage.gif" border="0" alt="" /> $thread[pagenav]<if condition="$show[pagenavmore]">... <a href="$vboptions[bburl]/showthread.php?$session[sessionurl]t=$thread[threadid]&amp;page=$thread[totalpages]">$vbphrase[last_page]</a></if>)</span>
		</if>
		<if condition="$thread[\'rating\']">
			<span style="float:$stylevar[right]"><img alt="" src="$stylevar[imgdir_rating]/rating_$thread[rating].gif" title="<phrase 1="$thread[votenum]" 2="$thread[voteavg]">$vbphrase[thread_rating_x_votes_y_average]</phrase>" /></span>
		</if>
		<if condition="$mod_options[\'portal_threads_threadstarter\']">
			<div class="smallfont">
				<if condition="$thread[postuserid]">
					<span style="cursor:pointer" onclick="window.open(\'$vboptions[bburl]/member.php?$session[sessionurl]u=$thread[postuserid]\')">$thread[postusername]</span>
				<else />
					$thread[postusername]
				</if>
			</div>
		</if>
		<if condition="$mod_options[\'portal_threads_showdate\']">
			<div class="smallfont">$thread[postdate] <span class="time">$thread[posttime]</span></div>
		</if>
	</td>
	<if condition="$show[\'lastpost\']">
		<td class="alt2">
			<div class="smallfont" style="text-align:$stylevar[right]; white-space:nowrap">
				$thread[lastpostdate] <span class="time">$thread[lastposttime]</span><br />
				<phrase 1="$vboptions[bburl]/member.php?$session[sessionurl]find=lastposter&amp;t=$thread[threadid]" 2="$thread[lastposter]">$vbphrase[by_x]</phrase> <a href="$vboptions[bburl]/showthread.php?$session[sessionurl]p=$thread[lastpostid]#post$thread[lastpostid]"><img alt="" border="0" src="$stylevar[imgdir_button]/lastpost.gif" title="$vbphrase[go_to_last_post]" /></a>
			</div>
		</td>
	</if>
	<if condition="$mod_options[\'portal_threads_replies\']">
		<td align="center" class="$class_reply"><span class="smallfont">$thread[replycount]</span></td>
	</if>
	<if condition="$mod_options[\'portal_threads_views\']">
		<td align="center" class="$class_view"><span class="smallfont">$thread[views]</span></td>
	</if>
	<if condition="$mod_options[\'portal_threads_showforum\']">
		<td class="$class_ftitle"><span class="smallfont"><a href="$vboptions[bburl]/forumdisplay.php?$session[sessionurl]f=$thread[forumid]">$thread[forumtitle]</a></span></td>
	</if>
</tr>',


'adv_portal_recthreads_exp_head' =>
'<tr>
	<if condition="$mod_options[\'portal_threads_showicon\']">
		<td class="thead" width="2%">&nbsp;</td>
	</if>
	<td class="thead" width="50%"><if condition="$mod_options[\'portal_threads_showrating\']"><span style="float:$stylevar[right]">$vbphrase[rating]</span></if>$vbphrase[title_username_date]</td>
	<if condition="$mod_options[\'portal_threads_lastpost\']">
		<td align="center" class="thead" style="white-space: nowrap" width="25%">$vbphrase[last_post]</td>
	</if>
	<if condition="$mod_options[\'portal_threads_replies\']">
		<td class="thead" width="2%">$vbphrase[replies]</td>
	</if>
	<if condition="$mod_options[\'portal_threads_views\']">
		<td class="thead" width="2%">$vbphrase[views]</td>
	</if>
	<if condition="$mod_options[\'portal_threads_showforum\']">
		<td align="center" class="thead" width="20%">$vbphrase[forum]</td>
	</if>
</tr>',


'adv_portal_recthreads_lean' =>
'<tr>
	<td class="$bgclass">
		<div class="smallfont">
			<if condition="$show[\'paperclip\'] OR ($thread[\'sticky\'] AND $mod_options[\'portal_threads_stickyicon\'])">
				<span style="float:$stylevar[right]">
					<if condition="$show[\'paperclip\']">
						<a href="#" onclick="vba_attach_win($thread[threadid]); return false"><img class="inlineimg" src="$stylevar[imgdir_misc]/paperclip.gif" border="0" title="<phrase 1="$thread[attach]">$vbphrase[x_attachments]</phrase>" alt="" /></a>
					</if>
					<if condition="$thread[\'sticky\'] AND $mod_options[\'portal_threads_stickyicon\']">
						<img class="inlineimg" src="$stylevar[imgdir_misc]/sticky.gif" title="$vbphrase[sticky_thread]" alt="" />
					</if>
				</span>
			</if>

			<if condition="$show[\'threadicon\']">
				<img class="inlineimg" src="$thread[threadiconpath]" title="$thread[threadicontitle]" border="0" alt="" />
			</if>
			<if condition="$thread[\'subscribed\']">
				<img alt="" class="inlineimg" src="$stylevar[imgdir_misc]/subscribed.gif" title="$vbphrase[you_are_subscribed_to_this_thread]" />
			</if>
			<if condition="$mod_options[\'portal_threads_newpostarrow\'] AND $show[\'gotonewpost\']">
				<a href="$vboptions[bburl]/showthread.php?$session[sessionurl]t=$thread[threadid]&amp;goto=newpost"><img alt="$vbphrase[go_to_first_new_post]" src="$stylevar[imgdir_button]/firstnew.gif" border="0" class="inlineimg" /></a>
			</if>
			$thread[prefix] <a href="$vboptions[bburl]/showthread.php?$session[sessionurl]t=$thread[threadid]" title="<if condition="$thread[preview]">$thread[preview]</if>"><if condition="$show[\'gotonewpost\']"><strong>$thread[title]</strong><else />$thread[title]</if></a>
			<if condition="$mod_options[\'portal_threads_multipage\'] AND $show[\'pagenav\']">
				(<img class="inlineimg" src="$stylevar[imgdir_misc]/multipage.gif" border="0" alt="" /> $thread[pagenav]<if condition="$show[pagenavmore]">... <a href="$vboptions[bburl]/showthread.php?$session[sessionurl]t=$thread[threadid]&amp;page=$thread[totalpages]">$vbphrase[last_page]</a></if>)
			</if>
			<if condition="$mod_options[\'portal_threads_showdate\']">
				<div>$thread[postdate] <span class="time">$thread[posttime]</span></div>
			</if>
			<if condition="$thread[\'rating\']">
				<span style="padding-top:$stylevar[cellpadding]px; float: $stylevar[right]"><img alt="" src="$stylevar[imgdir_rating]/rating_$thread[rating].gif" title="<phrase 1="$thread[votenum]" 2="$thread[voteavg]">$vbphrase[thread_rating_x_votes_y_average]</phrase>" /></span>
			</if>
			<if condition="$mod_options[\'portal_threads_threadstarter\']">
	 			<div>
	 				<if condition="$thread[postuserid]">
						<phrase 1="$vboptions[bburl]/member.php?$session[sessionurl]u=$thread[postuserid]" 2="$thread[postusername]">$vbphrase[by_x]</phrase>
					<else />
						$vbphrase[by] $thread[postusername]
					</if>
				</div>
			</if>

			<if condition="$mod_options[\'portal_threads_showforum\']">
				<div style="padding-top:$stylevar[cellpadding]px"><a href="$vboptions[bburl]/forumdisplay.php?$session[sessionurl]f=$thread[forumid]">$thread[forumtitle]</a></div>
			</if>
			<if condition="$show[\'lastpost\']">
				<div style="padding-top:$stylevar[cellpadding]px"><a href="$vboptions[bburl]/showthread.php?$session[sessionurl]p=$thread[lastpostid]#post$thread[lastpostid]"><img alt="" border="0" src="$stylevar[imgdir_button]/lastpost.gif" title="$vbphrase[go_to_last_post]" /></a> $vbphrase[last_post_by] <a href="$vboptions[bburl]/member.php?$session[sessionurl]find=lastposter&amp;t=$thread[threadid]">$thread[lastposter]</a></div>
				<div>$thread[lastpostdate] <span class="time">$thread[lastposttime]</span></div>
			</if>
			<if condition="$mod_options[\'portal_threads_replies\'] OR $mod_options[\'portal_threads_views\']">
				<div style="padding-top:$stylevar[cellpadding]px"><if condition="$mod_options[\'portal_threads_replies\']">$thread[replycount] $vbphrase[replies]</if>$recthreads_comma <if condition="$mod_options[\'portal_threads_views\']">$thread[views] $vbphrase[views]</if></div>
			</if>
		</div>
	</td>
</tr>',


'adv_portal_search' =>
'<tr>
<td class="$bgclass">
	<input class="bginput" name="query" size="13" type="text" /> $gobutton
	<div class="smallfont">&raquo; <a href="$vboptions[bburl]/search.php$session[sessionurl_q]">$vbphrase[advanced_search]</a></div>
</td>
</tr>',


'adv_portal_stats' =>
'<tr>
	<td class="$bgclass">
		<span class="smallfont">
			<if condition="$mod_options[\'portal_stats_members\']">$vbphrase[members]: $numbermembers<br /></if>
			<if condition="$mod_options[\'portal_stats_threads\']">$vbphrase[threads]: $totalthreads<br /></if>
			<if condition="$mod_options[\'portal_stats_posts\']">$vbphrase[posts]: $totalposts<br /></if>
			<if condition="$mod_options[\'portal_stats_topposter\']">$vbphrase[top_poster]: <a href="$vboptions[bburl]/member.php?$session[sessionurl]u=$topposter[userid]">$topposter[username]</a> ($topposter[posts])<br /></if>
			$template_hook[adv_portal_stats]
		</span>
	</td>
</tr>
<if condition="$mod_options[\'portal_stats_newestmember\']">
	<tr>
		<td class="$altbgclass"><span class="smallfont"><phrase 1="$vboptions[bburl]/member.php?$session[sessionurl]u=$newuserid" 2="$newusername">$vbphrase[welcome_to_our_newest_member_x]</phrase></span></td>
	</tr>
</if>',


'adv_portal_welcomeblock_expanded' =>
'<tr>
	<td class="$bgclass">

		<if condition="!$show[\'guest\']">

			<if condition="$avatarurl">
				<a href="$vboptions[bburl]/profile.php?$session[sessionurl]do=editavatar"><img src="$avatarurl" border="0" alt="$vbphrase[edit_avatar]" /></a>
				</td>
				<td class="$altbgclass" valign="top" width="100%">
			</if>
				<if condition="$bbuserinfo[\'reputationdisplay\'] OR ($bbuserinfo[\'rank\'] AND $mod_options[\'portal_welcome_rank\'])">
					<div class="smallfont" style="float:$stylevar[right]">
					<if condition="$bbuserinfo[\'reputationdisplay\']">
						$vbphrase[rep_power]: $reppower
						<div align="$stylevar[right]" style="padding-bottom:$stylevar[cellpadding]px">$bbuserinfo[reputationdisplay]</div>
					</if>
					<if condition="$bbuserinfo[\'rank\'] AND $mod_options[\'portal_welcome_rank\']">
						<div align="$stylevar[right]" style="padding-top:$stylevar[cellpadding]px; padding-bottom:$stylevar[cellpadding]px">$bbuserinfo[rank]</div>
					</if>
					</div>
				</if>

				<span class="smallfont"><phrase 1="$bbuserinfo[username]">$vbphrase[welcome_back_x]</phrase><br />
				<phrase 1="$lastvisitdate" 2="$lastvisittime">$vbphrase[last_visited_x_at_y]</phrase><br />
				<if condition="$mod_options[\'portal_welcome_newposts\']">
					<a href="$vboptions[bburl]/search.php?$session[sessionurl]do=getnew">$vbphrase[new_posts]</a>: $newposts<br />
				</if>

				<a href="$vboptions[bburl]/login.php?$session[sessionurl]do=logout&amp;logouthash=$bbuserinfo[logouthash]" onclick="return log_out(\'$vbphrase[sure_you_want_to_log_out]\')">$vbphrase[log_out]</a></span>

				<if condition="$mod_options[\'portal_welcome_newpms\'] AND $show[\'pmstats\']">
						</td>
					</tr>
					<tr>
						<td class="thead" colspan="2"><a href="$vboptions[bburl]/private.php$session[sessionurl_q]">$vbphrase[private_messages]</a></td>
					</tr>
					<tr>
						<td class="$bgclass" colspan="2"><span class="smallfont"><phrase 1="$bbuserinfo[pmunread]" 2="$bbuserinfo[pmtotal]" 3="$permissions[pmquota]">$vbphrase[x_new_have_y_of_z_allowed]</phrase></span>
				</if>
		<else />

			<table width="100%" cellspacing="3" cellpadding="0">
				<tr>
					<td style="white-space: nowrap" class="smallfont">$vbphrase[user_name]</td>
					<td><input class="bginput" name="vb_login_username" size="12" type="text" tabindex="577" /></td>
					<td style="white-space: nowrap" class="smallfont"><input checked="checked" class="bginput" name="cookieuser" id="cb_cookieuser" type="checkbox" value="1" /><label for="cb_cookieuser">$vbphrase[remember_me]</label></td>
					<td align="center" rowspan="2" width="100%"><phrase 1="$vboptions[bburl]">$vbphrase[not_a_member_yet_register_now]</phrase></td>
				</tr>
				<tr>
					<td class="smallfont">$vbphrase[password]</td>
					<td><input class="bginput" name="vb_login_password" size="12" type="password" tabindex="578" /></td>
					<td><input class="button" type="submit" value="$vbphrase[log_in]" tabindex="579" /></td>
				</tr>
			</table>

		</if>

	</td>
</tr>',


'adv_portal_welcomeblock_lean' =>
'<tr>
	<td class="$bgclass">

		<if condition="$bbuserinfo[\'userid\']">
			<span class="smallfont"><phrase 1="$bbuserinfo[username]">$vbphrase[welcome_back_x]</phrase></span><br />

		<if condition="$avatarurl">
			<div style="padding:4px">
				<a href="$vboptions[bburl]/profile.php?$session[sessionurl]do=editavatar"><img src="$avatarurl" border="0" alt="$vbphrase[edit_avatar]" /></a>
			</div>
		</if>
		<div class="smallfont">
		<phrase 1="$lastvisitdate" 2="$lastvisittime">$vbphrase[last_visited_x_at_y]</phrase><br />
		<if condition="$mod_options[\'portal_welcome_newposts\']">
			<a href="$vboptions[bburl]/search.php?$session[sessionurl]do=getnew">$vbphrase[new_posts]</a>: $newposts<br />
		</if>

		<if condition="$bbuserinfo[\'reputationdisplay\']">
			<div style="padding-top:$stylevar[cellpadding]px; padding-bottom:$stylevar[cellpadding]px">$vbphrase[rep_power]: $reppower<br />
			$bbuserinfo[reputationdisplay]</div>
		</if>
		<if condition="$bbuserinfo[\'rank\'] AND $mod_options[\'portal_welcome_rank\']">
			<div style="padding-top:$stylevar[cellpadding]px; padding-bottom:$stylevar[cellpadding]px">$bbuserinfo[rank]</div>
		</if>

		<a href="$vboptions[bburl]/login.php?$session[sessionurl]do=logout&amp;logouthash=$bbuserinfo[logouthash]" onclick="return log_out(\'$vbphrase[sure_you_want_to_log_out]\')">$vbphrase[log_out]</a></div>

		<if condition="$mod_options[\'portal_welcome_newpms\'] AND $show[\'pmstats\']">
			</td>
			</tr>
			<tr>
			<td class="thead"><a href="$vboptions[bburl]/private.php$session[sessionurl_q]">$vbphrase[private_messages]</a></td>
			</tr>
			<tr>
			<td class="$altbgclass"><span class="smallfont"><phrase 1="$bbuserinfo[pmunread]" 2="$bbuserinfo[pmtotal]" 3="$permissions[pmquota]">$vbphrase[x_new_have_y_of_z_allowed]</phrase></span>
		</if>

		<else />
			<div class="smallfont" style="padding:$stylevar[cellpadding]px">$vbphrase[user_name]:<br />
				<input class="bginput" name="vb_login_username" size="12" type="text" tabindex="577" /><br />
				$vbphrase[password]:<br />
				<input class="bginput" name="vb_login_password" size="12" type="password" tabindex="578" /><br />
				<input checked="checked" class="bginput" name="cookieuser" id="cb_cookieuser" type="checkbox" value="1" /><label for="cb_cookieuser">$vbphrase[remember_me]</label>

				<div style="padding-top:$stylevar[cellpadding]px; padding-bottom:$stylevar[cellpadding]px;">
					<input class="button" type="submit" value="$vbphrase[log_in]" tabindex="579" />
				</div>

			<phrase 1="$vboptions[bburl]">$vbphrase[not_a_member_yet_register_now]</phrase>
			</div>

		</if>

	</td>
</tr>');


// ##### Phrases ##############################################################
$mainphrases['adv_portal'] = array(
	'active_users' => 'Active Users',
	'buddies' => 'buddies',
	'by' => 'By',
	'comment_on_this_poll' => 'Comment On This Poll',
	'customize_this_page' => 'Customize This Page',
	'edit_this_post' => 'Edit This Post',
	'exit_customization_mode' => 'Exit Customization Mode',
	'last_post_by' => 'Last post by',
	'latest_forum_topics' => 'Latest Forum Topics',
	'new_pms' => 'New PMs',
	'no_x_online' => '<span class="smallfont">No {1} online</span>',
	'no_x_to_display' => 'No {1} to Display.',
	'not_a_member_yet_register_now' => 'Not a member yet?<br />
<a href="{1}/register.php">Register Now!</a>',
	'online_buddies' => 'Online Buddies',
	'pm' => 'PM',
	'poll_results' => 'Poll Results',
	'powered_by_vbadvanced_cmps' => 'Powered by <a href="http://www.vbadvanced.com/" target="_blank">vBadvanced</a> CMPS v{1}',
	'rating' => 'Rating',
	'read_more' => ' <span class="smallfont">[<a href="{1}/showthread.php?{3}t={2}">Read More</a>]</span>',
	'remove_from_buddy_list' => 'Remove from buddy list',
	'rep_power' => 'Rep Power',
	'reply_to_this_post' => 'Reply to This Post',
	'reset_layout' => 'Reset Layout',
	'send_to_friend' => 'Send to Friend',
	'show_printable_version' => 'Show Printable Version',
	'sorry_only_vb_37' => 'Sorry, but this module will not work with vBulletin versions prior to v3.7.',
	'this_poll_has' => 'This Poll Has',
	'title_username_date' => 'Title, Username, &amp; Date',
	'top_poster' => 'Top Poster',
	'total_votes' => 'Total Votes',
	'vote' => 'Vote',
	'welcome_back_x' => 'Welcome back <strong>{1}</strong>',
	'x_new_have_y_of_z_allowed' => '{1} New PMs. You have {2} total out of {3} allowed.'
);

$mainphrases['adv_portal_cp'] = array(
	'active' => 'Active',
	'active_set_to_no_disable' => 'Active

<div class="smallfont">Setting this option to \'No\' will prevent this module from being shown on any pages.</div>',
	'active_modules' => 'Active Modules',
	'add_child_page' => 'Add Child Page',
	'add_module' => 'Add Module',
	'add_more' => 'Add More',
	'add_page' => 'Add Page',
	'add_remove_from_pages' => 'Add/Remove From Pages',
	'add_remove_modules_from_pages' => 'Add/Remove Modules From Pages',
	'add_setting' => 'Add Setting',
	'advanced_options' => 'Advanced Options',
	'advanced_options_description' => 'Here you may specify a different value for any default settings that will apply only to this page. Click the + image next to a group or module\'s title to expand the settings for that group. If you have previously customized a setting and wish to revert this page back to using the default value, check the &quot;Use Default&quot; checkbox to the right of that setting\'s title and then save this page.',
	'allow_html' => 'Allow HTML',
	'allow_image_code' => 'Allow [IMG] code',
	'allow_page_customization' => 'Allow Page Customization<div class="smallfont">When this setting is enabled, your members will see a \'Customize This Page\' link that will allow them to re-arrange the active modules on this page and set a custom layout visible only to them.',
	'allow_smilies' => 'Allow Smilies',
	'also_delete_module_file_x' => 'Also delete the file &quot;modules/{1}&quot;',
	'also_delete_template_x' => 'Also delete the template called &quot;adv_portal_{1}&quot;',
	'alternative_module_wrapper_template' => 'Alternative Module Wrapper Template<div class="smallfont">If you would like, you may specify a different template to wrap around the contents of this module by entering its title here. If left blank, this module will use the \'adv_portal_module_wrapper\' template instead if the setting above is enabled.</div>',
	'are_you_sure_delete_module_called_x' => 'Are you sure you want to delete the module called <strong>{1}</strong>?<br />
This action can <strong>NOT</strong> be undone.',
	'are_you_sure_delete_page_called_x' => 'Are you sure you want to delete the page called <strong>{1}</strong>?<br />
This action can <strong>NOT</strong> be undone.',
	'bb_code' => 'BB Code',
	'bbcode_allows_bbcode' => 'BB Code {1}s allow you to use the vBulletin text editor to format your {2} using BB code. BB Code {1}s are recommended for simpler {2}s containing text, images, or anything else that can be done using BB code. Allowing HTML code is optional, but a Template {1} is recommended for anything more than light HTML formatting.',
	'center_column' => 'Center Column',
	'change_x_type' => 'Change {1} Type',
	'change_x_type_note' => 'You are about to change this {1} from a {2} {1} to a {3} {1}. Please note that once you hit the \'Save\' button below any previous information that was stored in the \'{2} {1} Type Options\' will be lost. However, you may change the type of this {1} back at any time.',
	'change_x_type_to' => 'Change {1} Type To',
	'choose_a_file' => 'Choose a File',
	'clean_file_output' => 'Clean File Output
<div class="smallfont">If your are trying to include a PHP file that was not written specifically for vBulletin or vBadvanced, it may be necessary to &quot;clean&quot; the output of this file. If you add a module and the content prints out as the first thing on the top your page, this is a good indication that it needs to be cleaned.</div>',
	'cmps_page_to_integrate_with' => 'CMPS Page to Integrate With',
	'cmps_page_to_integrate_with_desc' => 'Select the default CMPS page that you would like to use to integrate with and &quot;wrap around&quot; your files.<br /> You will also be able to change the page used with each file in the next step, but selecting a page here may save you time as each file will have this page pre-selected.<div style="padding-top: 4px">Note: Only CMPS &quot;Module&quot; pages with the &quot;Custom Page Content&quot; module enabled may be selected here. Other pages will be visible, but disabled.</div>',
	'cmps_product_inactive' => 'vBadvanced CMPS is disabled in your vBulletin <a href="plugin.php?do=product">Installed Products</a> section. Please enable vBadvanced CMPS in order for it to work.',
	'collapse_module_by_default' => 'Collapse Module by Default<div class="smallfont">Turn this option on if you would like this module to appear collapsed and require your users to click the &quot;expand&quot; image before revealing the content of the module. Note that your &quot;Enable Collapsible Modules&quot; setting must be enabled for this to work.',
	'content' => 'Content',
	'copy' => 'Copy',
	'copy_page' => 'Copy Page',
	'copy_module' => 'Copy Module',
	'copy_module_layout' => 'Copy Module Layout',
	'copy_module_layout_from_another_page' => 'Copy Module Layout From Another Page',
	'copying_x_note' => 'You have selected to copy your {1} titled &quot;{2}&quot;. Change any of the options below as you would like and then hit the &quot;Save&quot; button to add the new {1}.',
	'current_integrated_pages' => 'Current Integrated Pages',
	'current_selected_threads' => 'Current Selected Threads',
	'currently_running_latest_available' => 'You are currently running vBadvanced CMPS v{1}.<br />
<br />
The latest version available is {2}.<br />

<br />
{3}',
	'custom_content_title' => 'Custom Content Title
<div class="smallfont">This is what will be placed in the header row of your wrapper template.',
	'custom_page_content_description' => 'This module is used to display the various types of content from your pages. For example, if you add a Template Page, the content of the template specified on that page will be output within this module.',
	'custom_page_content_desc' => 'Custom Page Content<div class="smallfont">This is where the content from the {1} above will be displayed.</div>',
	'custom_page_content_integrate_desc' => 'Custom Page Content<div class="smallfont">If this page is used for integration, the content from the integrated file will be displayed here. Otherwise this module should be left inactive.</div>',

	'custom_style_for_this_page' => 'Custom Style for this Page',
	'custom_style_for_this_page_desc' => 'If you would like, you may select a style to use for this page. If a style is selected, that style will override your default vBulletin or any user chosen style settings on this page.',
	'date_created' => 'Date Created',
	'delete_page_integrated_files' => 'The following files/THIS_SCRIPT constants have been integrated with this page. Please choose to either remove the integration or integrate these with a different CMPS page below.',
	'display_order_page_desc' => 'This controls the order that the page will be displayed in for the Site Navigation module and in the Admin CP.',
	'dot_xml' => '.xml',
	'dot_module_serialized_data' => '.module (serialized data)',
	'download_file_type' => 'Download File Type',
	'download_module' => 'Download Module',
	'duplicate_filename' => 'Duplicate Filename',
	'duplicate_filename_desc' => '<div class="smallfont">You already have a file called <strong>{1}</strong> in your modules folder. Please choose a different name for the file.',
	'duplicate_module_identifier' => 'Duplicate Module Identifier
',
	'duplicate_module_identifier_desc' => '<div class="smallfont">You already have a module with an identifier of \'{1}\'. Please select a different identifier.</div>',
	'dynamic' => 'Dynamic',
	'edit_module' => 'Edit Module',
	'edit_modules' => 'Edit Modules',
	'edit_page' => 'Edit Page',
	'edit_pages' => 'Edit Pages',
	'edit_setting' => 'Edit Setting',
	'edit_settings' => 'Edit Settings',
	'edit_template' => 'Edit Template',
	'edit_template_for_x_in_style' => 'Edit the template for this {1} in the following style: ',
	'edit_threads' => 'Edit Threads',
	'expanded' => 'Expanded',
	'file_allows_file' => 'PHP File {1}s will allow you to specify a file {3} that will be displayed as the content for the {2}. ',
	'file_to_include' => 'File to Include',
	'form_code' => 'Form Code
<div class="smallfont">If your module requires a &lt;form&gt; tag, you may enter the code for that form tag here. This allows for the code to be placed above the table and comply with XHTML standards.',
	'from_anywhere_on_your_server' => 'from anywhere on your server',
	'from_modules_directory' => 'from the <i>{vbulletin}</i>/modules/ directory on your server ',
	'here_specify_which_usergroups_access_page' => 'Here you may specify which usergroups will have access to this page.',
	'here_specify_which_usergroups_view_module' => 'Here you may specify which usergroups will be able to view this module.',
	'hide_page_in_site_navigation' => 'Hide this page in these modules:',
	'html_allows_html' => 'An HTML Page will allow you to specify a HTML file on your server to include which will be displayed as the content for this page.',
	'html_file' => 'HTML File',
	'identifier' => 'Identifier',
	'identifier_desc' => 'PHP file modules require a unique identifier to help identify the module and its settings. Please note that this cannot be changed later and the identifier used for each PHP module must be unique.',
	'choose_a_page_to_copy_layout_from' => 'If you would like, you may choose to copy the module layout from one of your previously created pages. Note that this will override any custom layout changes set below.',
	'inactive' => 'Inactive',
	'inactive_modules' => 'Inactive Modules',
	'initialize_bbcode_parser' => 'Initialize BB Code Parser<div class="smallfont">If this module uses vBulletin BB codes in any way, this option must be turned on.</div>',
	'initialize_forum_permissions' => 'Initialize Forum Permissions<div class="smallfont">If this module pulls information regarding your forums, threads, or posts, and you wish to apply your vBulletin forum permissions to this module, this option must be turned on.</div>',
	'initialize_ignored_users' => 'Initialize Ignored Users<div class="smallfont">If this module pulls information regarding your forum\'s threads, or posts, and you wish to prevent threads/posts from users on a member\'s ignore list or users listed in your &quot;Tachy Goes to Coventry&quot; vBulletin setting from being displayed, this option must be turned on.',
	'initialize_moderator_cache' => 'Initialize Moderator Cache/Permissions<div class="smallfont">If this module requires information for your moderator permissions (ie: uses the can_moderate() function), this option must be turned on to initialize your moderator permissions.',
	'integate_new_pages' => 'Integrate New Pages',
	'integration' => 'Integration',
	'integration_allows_you_include_cmps' => 'This tool will allow you to easily integrate your other vBulletin pages and hacks, thus &quot;wrapping&quot; a specified CMPS page around the content of your vBulletin page. Fill out the form below to get started.<div style="padding-top:4px"><strong>Note:</strong> Only CMPS &quot;Module&quot; Pages with the &quot;Custom Page Content&quot; module enabled may be used for integration. This is necessary as the &quot;Custom Page Content&quot; module is where the output from this page will be printed.</div>',
	'last_vote' => 'Last Vote',
	'lean' => 'Lean',
	'left_column' => 'Left Column',
	'level' => 'Level',
	'link' => 'Link',
	'main_options' => 'Main Options',
	'meta_description' => 'Meta Description
<div class="smallfont">Here you may enter a meta description for this page. Leave this setting blank to use your default vBulletin setting.</div>',
	'meta_keywords' => 'Meta Keywords
<div class="smallfont">Here you may enter a list of meta keywords for this page. Leave this setting blank to use your default vBulletin setting.</div>',
	'module' => 'Module',
	'module_allows_module' => 'A Module Page will allow you to select any of your modules which you would like to display on this page. Module pages may also be used to integrate other vBulletin pages and hacks using the \'Integration\' link in the left frame.',
	'module_cache' => 'Module Cache',
	'module_dragdrop_desc' => 'To arrange the modules on this page, click on the module title and drag it to the location you would like it to appear. To remove a module from this page, drag it to the Inactive Modules box to the left.<br /><br /><strong>Don\'t forget to save the page after making any changes!</strong>',
	'module_parent' => 'Module Parent
<div class="smallfont">With some select modules (such as the News Archive) it may be necessary to specify a parent module. If this module requires a parent module you may specify that parent here.</div>',
	'module_wrapper_template_options' => 'Module Wrapper Template Options',
	'module_title' => 'Module Title',
	'module_type' => 'Module Type',
	'modules' => 'Modules',
	'move_to' => 'Move to',
	'newer_version_available' => '<strong>There is a newer version of vBadvanced CMPS available!</strong><br />
<br />
Please check <a href="http://www.vbadvanced.com/" target="_blank">vBadvanced.com</a> for more info.
',
	'no_modules' => 'No Modules',
	'no_x_to_display' => 'No {1} to Display.',
	'note_integrates_any_file_with_same_name' => 'Note that this will integrate <strong>any</strong> files with the name(s) that use vBulletin as a back-end. If you have other programs or hacks that use vBulletin as a back-end and they use any of the filenames listed here, those files will be integrated as well. To avoid this, use the &quot;THIS_SCRIPT Integration Method&quot; option below for these files instead.',
	'option_code' => 'Option Code',
	'options_apply_to_module_wrapper' => 'This section deals with options that may be applied to your \'adv_portal_module_wrapper\' template. Please note that the options are only applicable if the \'Use Module Wrapper Template\' option below is set to \'Yes\'.',
	'order' => 'Order',
	'other_filenames_to_integrate' => 'Other Filenames to Integrate',
	'other_filenames_to_integrate_desc' => 'If you would like to integrate other file names that may not be listed above, simply enter the name of the file(s) here. Separate each file name with a carriage return (new line).',
	'overwrite_file_with_new_file' => 'Overwrite File With New File',
	'overwrite_templates' => 'Overwrite Templates
',
	'overwrite_templates_desc' => '<div class="smallfont">The following template(s) already exist in this style:</div>
<div class="smallfont" style="padding-top:5px; padding-bottom:5px">{1}</div>
<div class="smallfont">Select \'yes\' to overwrite your current templates with the new ones, or select no to keep your current templates.</div>',
	'page_active' => 'Page Active
<div class="smallfont">When set to \'No\', this page will only be visible to moderators and admins.</div>',
	'pages_active_on' => 'Pages Active On',
	'page_contains_following_sub_pages' => 'This page currently has the following sub-pages. If you do not wish to remove any of these pages as well, you must select a new parent page for any of the pages listed below.',
	'page_identifier' => 'Page Identifier',
	'page_identifier_example' => 'This is the variable that will be used in the URL to link to this page. For example, if this option is set to \'games\', then the link to this page would look like this: {1}?{2}=games</div>',
	'page_parentlists' => 'Page Parentlists',
	'page_title' => 'Page Title',
	'page_to_copy_from' => 'Page to Copy From',
	'page_type' => 'Page Type',
	'pages_to_copy_to' => 'Page(s) to Copy To',
	'parent_page' => 'Parent Page',
	'parent_page_desc' => 'Selecting a &quot;Parent Page&quot; here will display that page (and any parent pages of the page selected) in the navbits and other places, giving the appearance that this page is a sub-page of the page selected here.',
	'path_to_file' => 'Path to File
<div class="smallfont">Here you may specify the path to a file to include which will replace the content of your \'Custom Page Content\' module.</div>',
	'php_file' => 'PHP File',
	'please_select_a_page' => 'Please Select a Page',
	'please_select_type_of_x_to_add' => 'Please select which type of {1} you would like to add.',
	'plugins_inactive_x' => 'The following default plugins are inactive. Please enable them via the <a href="plugin.php?do=modify">Plugin Manager</a>.<br />{1}',
	'plugins_missing' => 'One or more of your vBadvanced CMPS plugins are missing. Please use the \'Reinstall the vBulletin plugins\' option from the \'Maintenance\' section of the admincp/vbacmps_install.php file to re-install the plugins.',
	'random' => 'Random',
	'rating' => 'Rating',
	'rebuild_x' => 'Rebuild {1}',
	'remove_module' => 'Remove Module',
	'rename_to_filename_entered_below' => 'Rename to Filename Entered Below',
	'right_column' => 'Right Column',
	'select_an_action' => 'Select an action',
	'select_module_upload' => 'Module to Upload<div class="smallfont">Please select a .module or .xml file from your computer to upload.</div>',
	'select_new_parent' => 'Select New Parent',
	'select_new_threads' => 'Select New Threads',
	'select_pages_to_integrate_and_save' => 'Select the CMPS page that you would like to integrate with each file or THIS_SCRIPT constant below. Once you have made your selections, click &quot;Save&quot; to finalize the integration.',
	'select_style_add_template_to' => 'If you are adding a new template to use with this module, please specify the style(s) you would like to add this template to here.<br />To select more than one style, hold down the \'Ctrl\' key while selecting styles with your mouse.',
	'serialize' => 'Serialize',
	'setting' => 'setting',
	'setting_customized_pages' => 'This setting has been customized in the following page(s): ',
	'setting_customized_pages_desc' => 'This setting has previously had a custom value set for it in the page(s) listed above. The value set in any of these pages will override the value set here. To change the value of this setting on these pages, you must edit the page and change the value there, or revert the setting on that page so it will use the value set here.',
	'settings_customized_marked_with_asterisk' => 'The settings below marked with a &quot;*&quot; have been customized on this page and the value set here will override the default setting on this page. If you wish to revert any of these settings so that the default value will be used for this page again, check the &quot;Use Default&quot; checkbox to the right of the setting\'s title and then save the page.',
	'show_all_settings' => 'Show All Settings',
	'showing_w_x_to_y_of_z' => 'Showing {1} {2} to {3} of {4}',
	'simple_calendar' => 'Simple Calendar',
	'style_to_install_to' => 'Style to install templates to
<div class="smallfont">If this module has any templates included, you must choose which style(s) you would like to install these templates to here.<br />To select more than one style, hold down the \'Ctrl\' key while selecting styles with your mouse.</div>',
	'thread_title' => 'Thread Title',
	'template' => 'Template',
	'template_allows_template' => 'Template {1}s allow you to include a template from the vBulletin Style Manager to be displayed as the content for the {2}. Template {1}s are recommended for more advanced HTML coding, and also allows you the benefits of using vBulletin\'s &quot;<a href="http://www.vbulletin.com/docs/html/template_conditionals" target="_blank">Template Conditionals</a>&quot; for dynamic content.',
	'template_content' => 'Template Content
<div class="smallfont">If you are adding a new {1} and the template does not already exist, you may enter the content for that template here. If the template already exists, simply leave this field blank. Please note as well that any changes to this template will need to be made via your \'Style Manager\'.</div>',
	'template_title' => 'Template Title',
	'note_templates_should_use_format' => 'Also note that all templates should use the following format if this setting is enabled:',
	'temlate_title_desc' => 'Enter the name of the template that you wish to display for the content of this page here.',
	'template_to_include' => 'Template to Include<div class="smallfont">Enter the name of the template that you wish to display with this module here. Note that all templates must be prefixed with \'adv_portal\' and that it is not necessary to enter this prefix.<br />Example: If your template is called \'adv_portal_games\', enter \'games\' in the box to the right.</div>',
	'templates_used' => 'Templates Used
<div class="smallfont">Here you may enter a list of any templates that are called within your PHP file and used in this module. This is necessary to cache the templates as well as figure out which templates belong to this module when downloading modules. Separate each template with a carriage return (new line).',
	'this_module' => 'this module',
	'this_script_integration_method' => 'THIS_SCRIPT Integration Method',
	'this_script_integration_method_desc' => 'Any default vBulletin file (and most vB hacks) will define the constant &quot;THIS_SCRIPT&quot; at or near the top of the file to help identify it. If you wish to integrate files but cannot use the filename options above, simply open the file you wish to integrate, look for the THIS_SCRIPT constant near the top, and enter the value here. Separate each THIS_SCRIPT value with a carriage return (new line).<br /><br />Example code to look for:<hr width="40%" align="{1}"><div>define(\'THIS_SCRIPT\', \'<strong><i>value</i></strong>\');</div><hr width="40%" align="{1}"><div style="padding-top:4px">From this example, you would enter \'value\' (without the quotes) in the box to the right.',
	'title_row_colspan' => 'Title Row Colspan
<div class="smallfont">If the module will have more than one table cell in the code which is output, you may set a colspan value here that will be placed in the main title row of the wrapper template.</div>',
	'to_begin_selecting_threads' => 'To begin selecting threads to display, first choose a forum to browse.',
	'to_remove_this_module' => 'To remove this module click the \'Remove Module\' button below.',
	'tool_downloads_module' => 'This tool will allow you to download a .xml or .module file which will contain all information (settings, templates, files, etc) that is associated with this module. This allows you to easily make backups of your modules and/or share your custom modules with others.',
	'tool_allows_copy_layouts' => 'This tool will allow you to copy your module layout and active modules from one page to others. Simply select the page that you wish to copy the layout from, check the page(s) that you wish to copy the module layout to, and then click &quot;Save&quot;.',
	'upload_module' => 'Upload Module',
	'urls' => 'URLs',
	'use_current_file_instead' => 'Use Current File Instead',
	'use_default' => 'Use Default',
	'use_default_style' => 'Use Default Style',
	'use_module_wrapper_must_be_enabled' => 'For this setting to have any effect, the "Use Module Wrapper Template" setting above must be enabled.\r\nWould you like to enable this setting now?',
	'use_module_wrapper_template' => 'Use Module Wrapper Template

<div class="smallfont">This option will &quot;wrap&quot; a template (\'<i>adv_portal_module_wrapper</i>\', unless an Alternative template is specified) around the output of this {1} template. This is intended to keep your modules uniform and make it easy to change the look of most all modules by editing one template.</div>',
	'usergroup_permissions' => 'Usergroup Permissions',
	'vba_dyna_copy' => 'This tool will allow you to import any module from your vBadvanced Dynamics instances for use with vBadvanced CMPS.',
	'vba_dyna_copy_module_text' => 'This tool will allow you to import any module from your vBadvanced Dynamics instances for use on vBadvanced CMPS pages. Simply select the module you would like to import and then click the button below.',
	'vba_dyna_module' => 'vBa Dynamics Module',
	'vbadvanced_cmps' => 'vBadvanced CMPS',
	'vbulletin_files_to_integrate' => 'vBulletin Files to Integrate',
	'vbulletin_files_to_integrate_desc' => 'Here you may select any file names from your vBulletin folder that you wish to integrate with the CMPS. To select more than one file, hold down the \'Ctrl\' key while selecting files with your mouse.',
	'vbulletin_forum_url' => 'vBulletin Forum URL',
	'version_info_unavailable' => 'vBadvanced version information is currently unavailable.',
	'view_edit_active_modules_on_this_page' => 'View / Edit Active Modules on This Page',
	'welcome_to_vba_cmps_control_panel' => 'Welcome to the vBadvanced CMPS Admin Control Panel',
	'x_link' => '{1} Link
<div class="smallfont">If you would like the title of this {1} to link to another page on your site you may enter the file that this {1} should link to here.</div>',
	'x_module' => '{1} Module',
	'x_modules' => '{1} Modules',
	'x_options' => '{1} Options',
	'x_page' => '{1} Page',
	'x_pages' => '{1} Page(s)',
	'x_settings_customized_for_this_page' => '{1} settings customized for this page',
	'x_tools' => '{1} Tools',
	'x_total_threads' => '{1} Total Threads',
	'x_y_options' => '{2} {1} Options',
	'yes_all_attachments' => 'Yes, All Attachments',
	'yes_first_attach_only' => 'Yes, First Attachment Only',
	'your_custom_content' => 'your \'Custom Page Content\' module',
	'your_vba_version_up_to_date' => 'Your version of vBadvanced CMPS is up to date.'
);

$mainphrases['error'] = array(
	'adv_portal_cant_remove_default' => 'You can\'t remove your default page!',
	'adv_portal_cant_parent_page_itself' => 'You cannot create a page that it is its own parent. Please go back and select a different parent page for this page.',
	'adv_portal_choose_style' => 'You must choose the style in which you wish to install the templates for this module to.',
	'adv_portal_custom_page_inactive' => 'The &quot;Custom Page Content&quot; module is not active on this page. This module is what is used to display the content from your {1}, and this content will not be visible on the page unless this module is active.',
	'adv_portal_duplicate_identifier' => 'You already have a {1} with an identifier of \'{2}\'. Please select a different identifier.',
	'adv_portal_integration_successfully_saved' => 'Your integration settings have been successfully saved.',
	'adv_portal_invalid_cmps_url' => 'Invalid URL: <a href="{1}" target="_blank">{1}</a>',
	'adv_portal_invalid_file_path' => 'The path you have specified for your {1} path is not a valid file on your server. Please go back and enter the full path (NOT the URL) to this file.',
	'adv_portal_invalid_modfile' => 'The file you have uploaded is not a valid module file.',
	'adv_portal_layouts_copied_successfully' => 'Your module layout has been copied successfully.',
	'adv_portal_moddir_notwritable' => 'Your modules directory is not writable. Please chmod your modules directory to 777 and try again.',
	'adv_portal_module_saved_add_to_pages' => 'Your module has been successfully saved. Click &quot;Go Back&quot; to add another module, or click &quot;Continue&quot; to activate this module on your CMPS pages.',
	'adv_portal_must_choose_php_file_include' => 'You must choose a PHP file to include!',
	'adv_portal_must_choose_template_include' => 'You must choose a template to include!',
	'adv_portal_must_choose_title_for_module' => 'You must choose a title for your module!',
	'adv_portal_must_choose_x_type' => 'You must choose a the type of {1} that you wish to add!',
	'adv_portal_must_enter_x_for_page' => 'You must choose a {1} for your page!',
	'adv_portal_no_files_to_integrate' => 'You have not selected anything to integrate.',
	'adv_portal_no_valid_integration_pages' => 'You do not currently have any pages that meet the qualifications necessary to be used for integration. <a href="vba_cmps_admin.php?do=addpage&type=module">Click here</a> to add a new &quot;Module&quot; page to be used for the integration.',
	'adv_portal_must_select_file_integrate' => 'You have not selected a CMPS page to integrate with one or more of your files. Please go back and ensure that you have selected a CMPS page to integrate with each filename and/or THIS_SCRIPT constant that you have chosen.',
	'adv_portal_old_modules_found' => 'One or more modules on this page have been disabled by the Administrator. These modules have been removed from your layout.',
	'adv_portal_page_saved_but_problems_found' => 'Your page has been saved, but the following problems were found: {1}',
	'adv_portal_required_modules_not_found' => 'One or more required modules were not found to be active on this page. These modules have been added to the bottom of the center column.',
	'adv_portal_suhosin' => 'A required field called pageid is missing or has an invalid value.<br />Please see the <a href="http://www.vbadvanced.com/forum/faq.php?faq=vba_trouble#faq_suhosin" target="_blank">vBadvanced FAQ</a> for more information regarding this error.',
	'adv_portal_template_exists' => 'A template named {1} already exists in this style. Please choose a different name for your template, a different style to install this template to, or simply leave the \'Template Content\' field blank. Please note that you may also edit this template through your \'Style Manager\'.',
	'adv_portal_threads_save_page' => 'We\'re sorry, but since you are adding a new page and this page has not yet been created, the threads cannot be saved properly. Please go back and save the page you were creating first. You will then you will be able to pick specific threads once you go back to edit the page.',
	'adv_portal_x_rebuilt' => '{1} Rebuilt'
);

$mainphrases['cphome'] = array(
	'vba_cmps' => 'vBa CMPS',
	'edit_modules' => 'Edit Modules',
	'edit_pages' => 'Edit Pages',
	'add_module' => 'Add Module',
	'add_page' => 'Add Page',
	'default_settings' => 'Default Settings',
	'download_upload_module' => 'Download / Upload Module',
	'quick_permissions_editor' => 'Quick Permissions Editor',
	'copy_module_layouts' => 'Copy Module Layouts',
	'integration' => 'Integration'
);

$mainphrases['vbsettings'] = array(
	'settinggroup_adv_portal_admin' => 'Admin CP Options',
	'settinggroup_adv_portal_main' => 'Main Options',
	'settinggroup_adv_portal_style' => 'Style Options',
	'settinggroup_adv_global' => 'Global vBadvanced Settings'
);

$mainphrases['style'] = array(
	'group_adv_cmps' => 'vBadvanced CMPS'
);

// ##### Settings #############################################################
$mainsettings['adv_global'] = array(
	'global_header_replace' => array(
		'title' => 'Header Replacements',
		'description' => 'Here you may enter a list of filenames that may appear in your header that should be prefixed with your Forum\'s URL.',
		'value' => "album.php\r\ncalendar.php\r\nfaq.php\r\nforumdisplay.php\r\ngroup.php\r\nlogin.php\r\nmember.php\r\nmemberlist.php\r\nonline.php\r\nprivate.php\r\nprofile.php\r\nregister.php\r\nsearch.php\r\nsubscription.php\r\ntags.php\r\nusercp.php",
		'optioncode' => 'textarea',
		'displayorder' => '1'
	),
	'global_navbar_replace' => array(
		'title' => 'Navbar Replacements',
		'description' => 'Here you may enter a list of filenames that should be prefixed with your Forum\'s URL.',
		'value' => "album.php\r\ncalendar.php\r\nfaq.php\r\nforumdisplay.php\r\ngroup.php\r\nlogin.php\r\nmember.php\r\nmemberlist.php\r\nonline.php\r\nprivate.php\r\nprofile.php\r\nregister.php\r\nsearch.php\r\nsubscription.php\r\ntags.php\r\nusercp.php",
		'optioncode' => 'textarea',
		'displayorder' => '2'
	),
	'global_footer_replace' => array(
		'title' => 'Footer Replacements',
		'description' => 'Here you may enter a list of filenames that may appear in your footer that should be prefixed with your Forum\'s URL.',
		'value' => "archive\r\nsendmessage.php\r\nprofile.php",
		'optioncode' => 'textarea',
		'displayorder' => '3'
	)
);


$mainsettings['adv_portal_birthdays'] = array(
	'portal_birth_newline' => array(
		'title' => 'Show Each Member on a New Line',
		'description' => 'Turn this option on if you would like each member with a birthday today to be displayed on a new line. Otherwise members will be separated by a comma.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '10',
		'serialize' => 0
	)
);

$mainsettings['adv_portal_calendar'] = array(
	'portal_calendarid' => array(
		'title' => 'Calendar to Display',
		'description' => 'Please select which calendar you would like to display events from in your mini calendar.',
		'value' => '1',
		'optioncode' => 'calendarselect',
		'displayorder' => '10',
		'serialize' => 0
	),
	'portal_calendar_birthdays' => array(
		'title' => 'Show Birthdays',
		'description' => 'Turn this option on to include your member\'s birthdays in the calendar events.',
		'value' => '0',
		'optioncode' => 'yesno',
		'displayorder' => '20',
		'serialize' => 0
	),
	'portal_calendar_cache' => array(
		'title' => 'Calendar Cache Update Frequency',
		'description' => 'Enter the amount of time (in hours) between calendar cache updates. This will allow your calendar events and data to be cached, preventing a number of queries from being executed each time this module is loaded. The downside to caching this data is that new events or birthdays will not be added until the next time the cache is updated. Set this option to 0 to disable calendar caching.',
		'value' => '12',
		'optioncode' => '',
		'displayorder' => '30',
		'serialize' => 0
	)
);

$mainsettings['adv_portal_latestthreads'] = array(
	'portal_threadids' => array(
		'title' => 'Threads',
		'description' => 'Here you may select specific threads to be displayed with this module.',
		'value' => 'a:0:{}',
		'optioncode' => 'threadselect',
		'displayorder' => '10',
		'serialize' => 1
	),
	'portal_threads_forumids' => array(
		'title' => 'Recent Threads Forums',
		'description' => 'Here you may select the forum(s) in which you would like to display recent threads from. To select more than one forum, hold down your \'Ctrl\' key while selecting the forums with your mouse. Leave this option blank to select threads from all forums.',
		'value' => '',
		'optioncode' => 'forumselect',
		'displayorder' => '20',
		'serialize' => 1
	),
	'portal_threads_maxthreads' => array(
		'title' => 'Number of Threads to Display',
		'description' => 'The maximum number of latest threads that you would like to display.',
		'value' => '10',
		'optioncode' => '',
		'displayorder' => '30',
		'serialize' => 0
	),
	'portal_threads_cutoffdate' => array(
		'title' => 'Cut-Off Date',
		'description' => 'Here you may enter a number of days that represents a threshold for recent threads. Any threads that have not had a reply since this number of days will not be included. This helps to prevent large table scans on forums with a large number of threads. Set this option to 0 for no limit.',
		'value' => '30',
		'optioncode' => '',
		'displayorder' => '40',
		'serialize' => 0
	),
	'portal_threads_maxchars' => array(
		'title' => 'Maximum Characters of Thread Title to Display',
		'description' => 'The maximum number of characters that should be displayed before the rest of a thread\'s title is replaced by \'...\'. Set this to 0 to display the entire title.',
		'value' => '25',
		'optioncode' => '',
		'displayorder' => '50',
		'serialize' => 0
	),
	'portal_threads_maxwordchars' => array(
		'title' => 'Maximum Characters of Each Word',
		'description' => 'The maximum number of characters a word may contain. Any threads that contain a word longer than the value set here will be trimmed to that value. This helps to prevent threads with extremely long words from stretching out the page.',
		'value' => '20',
		'optioncode' => '',
		'displayorder' => '60',
		'serialize' => 0
	),
	'portal_threads_orderby' => array(
		'title' => 'Thread Display Order',
		'description' => 'The field in which threads should be ordered by.',
		'value' => 'lastpost',
		'optioncode' => '<select name=\\"$name\\" " . $jsdefault_onchange . " class=\\"bginput\\" tabindex=\\"1\\">
	<option " . iif($setting[value] == \'lastpost\', \'selected=\\"selected\\"\'). " value=\\"lastpost\\">$vbphrase[last_post]</option>
	<option " . iif($setting[value] == \'dateline\', \'selected=\\"selected\\"\'). " value=\\"dateline\\">$vbphrase[date_created]</option>
	<option " . iif($setting[value] == \'title\', \'selected=\\"selected\\"\'). " value=\\"title\\">$vbphrase[thread_title]</option>
	<option " . iif($setting[value] == \'voteavg\', \'selected=\\"selected\\"\'). " value=\\"voteavg\\">$vbphrase[rating]</option>
	<option " . iif($setting[value] == \'replycount\', \'selected=\\"selected\\"\'). " value=\\"replycount\\">$vbphrase[replies]</option>
	<option " . iif($setting[value] == \'views\', \'selected=\\"selected\\"\'). " value=\\"views\\">$vbphrase[views]</option>
</select>',
		'displayorder' => '70',
		'serialize' => 0
	),
	'portal_threads_direction' => array(
		'title' => 'Thread Display Direction',
		'description' => 'The direction in which threads should appear in.',
		'value' => 'DESC',
		'optioncode' => '<select name=\\"$name\\" " . $jsdefault_onchange . " class=\\"bginput\\" tabindex=\\"1\\">
	<option " . iif($setting[value] == \'ASC\', \'selected=\\"selected\\"\'). " value=\\"ASC\\">$vbphrase[ascending]</option>
	<option " . iif($setting[value] == \'DESC\', \'selected=\\"selected\\"\'). " value=\\"DESC\\">$vbphrase[descending]</option>
</select>',
		'displayorder' => '80',
		'serialize' => 0
	),
	'portal_threads_expanded' => array(
		'title' => 'Use Expanded Threads Template',
		'description' => 'This option can be used to switch between the \'adv_portal_recthreads_lean\' and \'adv_portal_recthreads_exp\' templates. Set this option to \'Dynamic\' if you would like for the module to try to automatically determine the best setting based on the size of the column it is activated in.',
		'value' => '2',
		'optioncode' => '<div class=\\"smallfont\\">
	<input name=\\"$name\\" id=\\"$setting[varname]_0\\" type=\\"radio\\" " . $jsdefault_onchange . " " . iif($setting[value] == 0, \'checked=\\"checked\\"\'). " value=\\"0\\" tabindex=\\"1\\"><label for=\\"$setting[varname]_0\\">$vbphrase[lean]</label><br />
	<input name=\\"$name\\" id=\\"$setting[varname]_1\\" type=\\"radio\\" " . $jsdefault_onchange . " " . iif($setting[value] == 1, \'checked=\\"checked\\"\'). " value=\\"1\\" tabindex=\\"1\\"><label for=\\"$setting[varname]_1\\">$vbphrase[expanded]</label><br />
	<input name=\\"$name\\" id=\\"$setting[varname]_2\\" type=\\"radio\\" " . $jsdefault_onchange . " " . iif($setting[value] == 2, \'checked=\\"checked\\"\'). " value=\\"2\\" tabindex=\\"1\\"><label for=\\"$setting[varname]_2\\">$vbphrase[dynamic]</label>
</div>',
		'displayorder' => '90',
		'serialize' => 0
	),
	'portal_applypermissions' => array(
		'title' => 'Apply Forum Permissions',
		'description' => 'Turn this option on to take your forum permissions into account and only show threads which the user has permission to view. ',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '100',
		'serialize' => 0
	),
	'portal_threads_threadstarter' => array(
		'title' => 'Show Thread Starter',
		'description' => 'Turn this option on to display the thread starter\'s username and a link to their profile.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '110',
		'serialize' => 0
	),
	'portal_threads_showdate' => array(
		'title' => 'Show Date & Time',
		'description' => 'Shows the time and date the thread was created.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '120',
		'serialize' => 0
	),
	'portal_threads_views' => array(
		'title' => 'Show Number of Views',
		'description' => 'Turn this option on to display the number of times the thread has been viewed.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '130',
		'serialize' => 0
	),
	'portal_threads_replies' => array(
		'title' => 'Show Number of Replies',
		'description' => 'Turn this option on to display the number of replies to a thread.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '140',
		'serialize' => 0
	),
	'portal_threads_lastpost' => array(
		'title' => 'Show Last Post Info',
		'description' => 'This option will display the last poster and time at which the last post was made.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '150',
		'serialize' => 0
	),
	'portal_threads_showforum' => array(
		'title' => 'Show Forum',
		'description' => 'Turn this option on to display the name of and link to the forum that the post was made in.',
		'value' => '0',
		'optioncode' => 'yesno',
		'displayorder' => '160',
		'serialize' => 0
	),
	'portal_threads_showpreview' => array(
		'title' => 'Show Preview of Threads',
		'description' => 'Turn this option on to show a preview of the first post in the thread when you hold your mouse over the title of the thread.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '170',
		'serialize' => 0
	),
	'portal_threads_showicon' => array(
		'title' => 'Show Thread Icons',
		'description' => 'Turn this option on to display the icon that was selected for the thread.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '180',
		'serialize' => 0
	),
	'portal_threads_showsubscribed' => array(
		'title' => 'Show Subscribed Icon',
		'description' => 'Turn this option on to display a \'subscribed\' icon next to the thread title if a user is subscribed to the thread.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '190',
		'serialize' => 0
	),
	'portal_threads_showrating' => array(
		'title' => 'Show Thread Ratings',
		'description' => 'Turn this option on to display the thread\'s rating.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '200',
		'serialize' => 0
	),
	'portal_threads_stickyicon' => array(
		'title' => 'Show Sticky Icon',
		'description' => 'Turn this option on if you would like to display the \'sticky\' icon next to threads that have been marked as &quot;sticky&quot;.',
		'value' => '0',
		'optioncode' => 'yesno',
		'displayorder' => '210',
		'serialize' => 0
	),
	'portal_threads_multipage' => array(
		'title' => 'Show Multi-Page Thread Links',
		'description' => 'Turn this option on to show a link to each individual page for threads that have span multiple pages.',
		'value' => '0',
		'optioncode' => 'yesno',
		'displayorder' => '220',
		'serialize' => 0
	),
	'portal_threads_showpaperclip' => array(
		'title' => 'Show Attachment Paperclip',
		'description' => 'Turn this option on to display the small \'paperclip\' icon showing the number of attachments in a thread.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '230',
		'serialize' => 0
	),
	'portal_threads_newpostarrow' => array(
		'title' => 'Show New Post Arrow',
		'description' => 'Turn this option on to display the "New Post" icon to allow users to go stright to the first unread post in the thread.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '240',
		'serialize' => 0
	),
	'portal_threads_prefix' => array(
		'title' => 'Show Prefix',
		'description' => 'Turn this option on if you would like to display the thread\'s prefix. Note this only works with vBulletin 3.7+.',
		'value' => '0',
		'optioncode' => 'yesno',
		'displayorder' => '250',
		'serialize' => 0
	)
);

$mainsettings['adv_portal_navigation'] = array(
	'portal_navigation_excludepages' => array(
		'title' => 'Pages to Exclude',
		'description' => 'Here you may select any pages which you do not wish to display with this module. To select more than one page, hold down your \'Ctrl\' key while selecting the pages with your mouse.',
		'value' => '',
		'optioncode' => 'pageselect',
		'displayorder' => '10',
		'serialize' => 1
	),
	'portal_navigation_mark1' => array(
		'title' => 'Level 1 Mark',
		'description' => 'This is what will be displayed next to a page\'s title if the page does not have a parent page, or is a custom link and has value of 1 for its level.',
		'value' => '&raquo;',
		'optioncode' => '',
		'displayorder' => '20',
		'serialize' => 0
	),
	'portal_navigation_mark2' => array(
		'title' => 'Level 2+ Mark',
		'description' => 'This is what will be displayed next to a page\'s title if the page has a parent, or is a custom link and has value of 2 or higher for its level.',
		'value' => '&gt;',
		'optioncode' => '',
		'displayorder' => '30',
		'serialize' => 0
	),
	'portal_navigation_addpages' => array(
		'title' => 'Additional Pages',
		'description' => 'Here you may enter any additional pages which you would like to display a link to in this module. Enter the URL you would like to link to under the \'Link\' column and the text to display under the \'Text\' column. The \'Level\' option below will indent the link the specified number spaces, giving the link the appearance of "belonging" to the first page above it with a lower level. Note that you may leave the URL field blank to display text without a link (useful for headings).',
		'value' => 'a:3:{i:0;a:4:{s:5:"order";s:1:"1";s:5:"level";s:1:"1";s:4:"link";s:65:"{$vbulletin->options[bburl]}/{$vbulletin->options[forumhome]}.php";s:4:"text";s:5:"Forum";}i:1;a:4:{s:5:"order";s:1:"2";s:5:"level";s:1:"2";s:4:"link";s:39:"{$vbulletin->options[bburl]}/usercp.php";s:4:"text";s:7:"User CP";}i:2;a:4:{s:5:"order";s:1:"3";s:5:"level";s:1:"2";s:4:"link";s:36:"{$vbulletin->options[bburl]}/faq.php";s:4:"text";s:3:"FAQ";}}',
		'optioncode' => 'pageselect_add',
		'displayorder' => '40',
		'serialize' => 1
	)
);


$mainsettings['adv_portal_news'] = array(
	'portal_threadids' => array(
		'title' => 'Threads',
		'description' => 'Here you may select specific threads to be displayed with this module.',
		'value' => 'a:0:{}',
		'optioncode' => 'threadselect',
		'displayorder' => '10',
		'serialize' => 1
	),
	'portal_news_forumid' => array(
		'title' => 'News Forum(s)',
		'description' => 'Here you may select the forum(s) in which you would like to display threads from in your news module. To select more than one forum, hold down your \'Ctrl\' key while selecting the forums with your mouse.',
		'value' => 'a:0:{}',
		'optioncode' => 'forumselect',
		'displayorder' => '20',
		'serialize' => 1
	),
	'portal_news_maxposts' => array(
		'title' => 'Maximum Number of Threads to Display',
		'description' => 'The maximum number of news threads to display. Setting this option to 0 will disable the module.',
		'value' => '5',
		'optioncode' => '',
		'displayorder' => '30',
		'serialize' => 0
	),
	'portal_news_threadsperpage' => array(
		'title' => 'Enable News Pagination',
		'description' => 'This option will allow you to enable a small page navigation section under your news module with links to additional pages of news threads. Enter the maximum number of pages that you would like to display here to enable this option.',
		'value' => '0',
		'optioncode' => '',
		'displayorder' => '40',
		'serialize' => 0
	),
	'portal_news_cutoffdate' => array(
		'title' => 'Cut-Off Date',
		'description' => 'Here you may enter a number of days that represents a threshold for news posts. Any threads before the current date minus this number of days will not be included. This helps to prevent large table scans on forums with a large number of threads. Set this option to 0 for no limit.',
		'value' => '90',
		'optioncode' => '',
		'displayorder' => '50',
		'serialize' => 0
	),
	'portal_news_maxchars' => array(
		'title' => 'Maximum Characters to Display',
		'description' => 'The maximum number of characters that you would like to display in a news post before it is replaced by the \'...[Read More]\' link. Set this option to 0 to display the entire message.',
		'value' => '500',
		'optioncode' => '',
		'displayorder' => '60',
		'serialize' => 0
	),
	'portal_news_dateformat' => array(
		'title' => 'Date & Time Format',
		'description' => 'The format in which the date and time will displayed in your news posts. Leave this blank if you do not wish to display the date/time a post was made.',
		'value' => 'M d, Y - g:i A',
		'optioncode' => '',
		'displayorder' => '70',
		'serialize' => 0
	),
	'portal_news_orderby' => array(
		'title' => 'Thread Display Order',
		'description' => 'The field in which threads should be ordered by.',
		'value' => 'postdateline',
		'optioncode' => '<select name=\\"$name\\" " . $jsdefault_onchange . " class=\\"bginput\\" tabindex=\\"1\\">
	<option " . iif($setting[value] == \'lastpost\', \'selected=\\"selected\\"\'). " value=\\"lastpost\\">$vbphrase[last_post]</option>
	<option " . iif($setting[value] == \'postdateline\', \'selected=\\"selected\\"\'). " value=\\"postdateline\\">$vbphrase[date_created]</option>
	<option " . iif($setting[value] == \'title\', \'selected=\\"selected\\"\'). " value=\\"title\\">$vbphrase[thread_title]</option>
	<option " . iif($setting[value] == \'voteavg\', \'selected=\\"selected\\"\'). " value=\\"voteavg\\">$vbphrase[rating]</option>
	<option " . iif($setting[value] == \'replycount\', \'selected=\\"selected\\"\'). " value=\\"replycount\\">$vbphrase[replies]</option>
	<option " . iif($setting[value] == \'views\', \'selected=\\"selected\\"\'). " value=\\"views\\">$vbphrase[views]</option>
</select>',
		'displayorder' => '80',
		'serialize' => 0
	),
	'portal_news_direction' => array(
		'title' => 'Thread Display Direction',
		'description' => 'The direction in which threads should appear in.',
		'value' => 'DESC',
		'optioncode' => '<select name=\\"$name\\" " . $jsdefault_onchange . " class=\\"bginput\\" tabindex=\\"1\\">
	<option " . iif($setting[value] == \'ASC\', \'selected=\\"selected\\"\'). " value=\\"ASC\\">$vbphrase[ascending]</option>
	<option " . iif($setting[value] == \'DESC\', \'selected=\\"selected\\"\'). " value=\\"DESC\\">$vbphrase[descending]</option>
</select>',
		'displayorder' => '90',
		'serialize' => 0
	),
	'portal_news_showattachments' => array(
		'title' => 'Enable Attachments',
		'description' => 'Turn this option on to display the attachments associated with each news post.',
		'value' => '0',
		'optioncode' => '<div class=\\"smallfont\\">
	<input name=\\"$name\\" id=\\"$setting[varname]_0\\" type=\\"radio\\" " . $jsdefault_onchange . " " . iif($setting[value] == 0, \'checked=\\"checked\\"\'). " value=\\"0\\" tabindex=\\"1\\"><label for=\\"$setting[varname]_0\\">$vbphrase[no]</label><br />
	<input name=\\"$name\\" id=\\"$setting[varname]_1\\" type=\\"radio\\" " . $jsdefault_onchange . " " . iif($setting[value] == 1, \'checked=\\"checked\\"\'). " value=\\"1\\" tabindex=\\"1\\"><label for=\\"$setting[varname]_1\\">$vbphrase[yes_first_attach_only]</label><br />
	<input name=\\"$name\\" id=\\"$setting[varname]_2\\" type=\\"radio\\" " . $jsdefault_onchange . " " . iif($setting[value] == 2, \'checked=\\"checked\\"\'). " value=\\"2\\" tabindex=\\"1\\"><label for=\\"$setting[varname]_2\\">$vbphrase[yes_all_attachments]</label>
</div>',
		'displayorder' => '100',
		'serialize' => 0
	),
	'portal_applypermissions' => array(
		'title' => 'Apply Forum Permissions',
		'description' => 'Turn this option on to take your forum permissions into account and only show threads which the user has permission to view. ',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '110',
		'serialize' => 0
	),
	'portal_news_allowreplies' => array(
		'title' => 'Show Reply Info',
		'description' => 'Turn this option on to display the number of replies that have been made to each post.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '120',
		'serialize' => 0
	),
	'portal_news_showviews' => array(
		'title' => 'Show Number of Views',
		'description' => 'Turn this option on to display the number of times a news thread has been viewed.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '130',
		'serialize' => 0
	),
	'portal_news_showavatar' => array(
		'title' => 'Show Avatars',
		'description' => 'Turn this option on to display the poster\'s avatar with your news posts.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '140',
		'serialize' => 0
	),
	'portal_news_showicon' => array(
		'title' => 'Show Post Icons',
		'description' => 'Turn this option on to display the icon selected for your news posts.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '150',
		'serialize' => 0
	),
	'portal_news_showrating' => array(
		'title' => 'Show Ratings',
		'description' => 'Turn this option on to display the post\'s rating.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '160',
		'serialize' => 0
	),
	'portal_news_showsubscribed' => array(
		'title' => 'Show Subscribed Thread Icon',
		'description' => 'Turn this option on to display a \'subscribed\' icon next to the thread title if a user is subscribed to the thread.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '170',
		'serialize' => 0
	),
	'portal_news_showprintable' => array(
		'title' => 'Show Printable Version Link',
		'description' => 'Turn this option on to display the \'printable version\' icon with a link to allow users to quickly print the thread.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '180',
		'serialize' => 0
	),
	'portal_news_showsendfriend' => array(
		'title' => 'Show Send to Friend Link',
		'description' => 'Turn this option on to display the \'send to friend\' icon with a link to allow users to email a link to the thread to friends.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '190',
		'serialize' => 0
	),
	'portal_news_showsignature' => array(
		'title' => 'Show Signatures',
		'description' => 'Turn this option on to show the poster\'s signature with the post. Note that the \'Show your signature\' option when making a post can still be used to disable signatures in selected posts.',
		'value' => '0',
		'optioncode' => 'yesno',
		'displayorder' => '200',
		'serialize' => 0
	),
	'portal_news_sticky' => array(
		'title' => 'Show Sticky Posts on Top',
		'description' => 'Turn this option on to cause threads that have been made sticky to appear at the top of the news section.',
		'value' => '0',
		'optioncode' => 'yesno',
		'displayorder' => '210',
		'serialize' => 0
	),
	'portal_news_legacy' => array(
		'title' => 'Separate News Posts',
		'description' => 'Turn this option on to display the posts separately rather than grouped together.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '220',
		'serialize' => 0
	),
	'portal_news_attachpaperclip' => array(
		'title' => 'Show Attachment Paperclip',
		'description' => 'Turn this option on to display the small \'paperclip\' icon showing the number of attachments in a thread.',
		'value' => '0',
		'optioncode' => 'yesno',
		'displayorder' => '230',
		'serialize' => 0
	),
	'portal_news_bbcode_attach' => array(
		'title' => 'Enable [ATTACH] BB Code Tags',
		'description' => 'Turn this option on if you would like to enable [ATTACH] BB code tags.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '240',
		'serialize' => 0
	),
	'portal_news_prefix' => array(
		'title' => 'Show Prefix',
		'description' => 'Turn this option on if you would like to display the thread\'s prefix. Note this only works with vBulletin 3.7+.',
		'value' => '0',
		'optioncode' => 'yesno',
		'displayorder' => '250',
		'serialize' => 0
	),
	'portal_news_postcache' => array(
		'title' => 'Use Post Cache',
		'description' => 'This option will cause news posts to use the vBulletin post cache (if enabled) rather than parsing the BB code each time the page is loaded. This will improve performance on web sites with a lot of news posts, but will disable the BB code options below and cause the module to use your news forums\' settings.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '260',
		'serialize' => 0
	),
	'portal_news_enablehtml' => array(
		'title' => 'Allow HTML',
		'description' => 'Turn this option on to allow HTML to be parsed in posts.',
		'value' => '0',
		'optioncode' => 'yesno',
		'displayorder' => '270',
		'serialize' => 0
	),
	'portal_news_enablevbcode' => array(
		'title' => 'Allow BB Code',
		'description' => 'Turn this option on to allow BB code to be parsed in posts.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '280',
		'serialize' => 0
	),
	'portal_news_enablevbimage' => array(
		'title' => 'Allow [IMG] Code',
		'description' => 'Turn this option on to allow the [IMG] code in posts.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '290',
		'serialize' => 0
	),
	'portal_news_enablesmilies' => array(
		'title' => 'Allow Smilies',
		'description' => 'Turn this option on to allow smilies in posts.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '300',
		'serialize' => 0
	)
);

$mainsettings['adv_portal_newsarchive'] = array(
	'portal_news_enablearchive' => array(
		'title' => 'Number of Archived News Posts to Display',
		'description' => 'The number of news posts you would like to display in the News Archive. Set this to 0 to disable the News Archive.',
		'value' => '5',
		'optioncode' => '',
		'displayorder' => '10',
		'serialize' => 0
	),
	'portal_archive_maxchars' => array(
		'title' => 'Maximum Characters of Thread Title to Display',
		'description' => 'The maximum number of characters that should be displayed before the rest of a thread\'s title is replaced by \'...\'. Set this to 0 to display the entire title.',
		'value' => '25',
		'optioncode' => '',
		'displayorder' => '20',
		'serialize' => 0
	),
	'portal_archive_expanded' => array(
		'title' => 'Use Expanded Archive Template',
		'description' => 'This option can be used to switch between the \'adv_portal_archivebits_lean\' and \'adv_portal_archivebits_exp\' templates. Set this option to \'Dynamic\' if you would like for the module to try to automatically determine the best setting based on the size of the column it is activated in.',
		'value' => '2',
		'optioncode' => '<div class=\\"smallfont\\">
	<input name=\\"$name\\" id=\\"$setting[varname]_0\\" type=\\"radio\\" " . $jsdefault_onchange . " " . iif($setting[value] == 0, \'checked=\\"checked\\"\'). " value=\\"0\\" tabindex=\\"1\\"><label for=\\"$setting[varname]_0\\">$vbphrase[lean]</label><br />
	<input name=\\"$name\\" id=\\"$setting[varname]_1\\" type=\\"radio\\" " . $jsdefault_onchange . " " . iif($setting[value] == 1, \'checked=\\"checked\\"\'). " value=\\"1\\" tabindex=\\"1\\"><label for=\\"$setting[varname]_1\\">$vbphrase[expanded]</label><br />
	<input name=\\"$name\\" id=\\"$setting[varname]_2\\" type=\\"radio\\" " . $jsdefault_onchange . " " . iif($setting[value] == 2, \'checked=\\"checked\\"\'). " value=\\"2\\" tabindex=\\"1\\"><label for=\\"$setting[varname]_2\\">$vbphrase[dynamic]</label>
</div>',
		'displayorder' => '30',
		'serialize' => 0
	),
	'portal_news_archivepreview' => array(
		'title' => 'Show Preview in Archive?',
		'description' => 'Turn this option on to show a preview of the first post in the archived thread when you hold your mouse over the title of the thread.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '40',
		'serialize' => 0
	),
	'portal_archive_threadstarter' => array(
		'title' => 'Show Thread Starter',
		'description' => 'Turn this option on to display the thread starter\'s username and a link to their profile.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '50',
		'serialize' => 0
	),
	'portal_archive_showdate' => array(
		'title' => 'Show Date & Time',
		'description' => 'Turn this option on to display the date and time the post was made.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '60',
		'serialize' => 0
	),
	'portal_archive_showviews' => array(
		'title' => 'Show Views',
		'description' => 'Turn this option on to display the number of times that the archived thread has been viewed.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '70',
		'serialize' => 0
	),
	'portal_archive_showreplies' => array(
		'title' => 'Show Replies',
		'description' => 'Turn this option on to display the number of replies that have been made to the archived thread.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '80',
		'serialize' => 0
	),
	'portal_newsarchive_lastpost' => array(
		'title' => 'Show Last Post Info',
		'description' => 'Turn this option on to display the last poster and time at which the last post was made.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '90',
		'serialize' => 0
	),
	'portal_newsarchive_showforum' => array(
		'title' => 'Show Forum',
		'description' => 'This option will display the name of and link to the forum that the thread was made in.',
		'value' => '0',
		'optioncode' => 'yesno',
		'displayorder' => '100',
		'serialize' => 0
	),
	'portal_archive_showrating' => array(
		'title' => 'Show Ratings',
		'description' => 'Turn this option on to display ratings with your archived threads.',
		'value' => '0',
		'optioncode' => 'yesno',
		'displayorder' => '110',
		'serialize' => 0
	),
	'portal_archive_showicon' => array(
		'title' => 'Show Post Icons',
		'description' => 'Turn this option on to display the icon selected for your news archive threads.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '120',
		'serialize' => 0
	),
	'portal_archive_showsubscribed' => array(
		'title' => 'Show Subscribed Thread Icon',
		'description' => 'Turn this option on to display a \'subscribed\' icon next to the thread title if a user is subscribed to the thread.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '130',
		'serialize' => 0
	),
	'portal_archive_stickyicon' => array(
		'title' => 'Show Sticky Icon',
		'description' => 'Turn this option on if you would like to display the \'sticky\' icon next to threads that have been marked as &quot;sticky&quot;.',
		'value' => '0',
		'optioncode' => 'yesno',
		'displayorder' => '140',
		'serialize' => 0
	),
	'portal_archive_multipage' => array(
		'title' => 'Show Multi-Page Thread Links',
		'description' => 'Turn this option on to show a link to each individual page for threads that have span multiple pages.',
		'value' => '0',
		'optioncode' => 'yesno',
		'displayorder' => '150',
		'serialize' => 0
	),
	'portal_archive_attachpaperclip' => array(
		'title' => 'Show Attachment Paperclip',
		'description' => 'Turn this option on to display the small \'paperclip\' icon showing the number of attachments in a thread.',
		'value' => '0',
		'optioncode' => 'yesno',
		'displayorder' => '160',
		'serialize' => 0
	)
);

$mainsettings['adv_portal_poll'] = array(
	'portal_threadids' => array(
		'title' => 'Threads',
		'description' => 'Here you may select specific threads to be displayed with this module.',
		'value' => '',
		'optioncode' => 'threadselect',
		'displayorder' => '10',
		'serialize' => 1
	),
	'portal_poll_forumid' => array(
		'title' => 'Polls Forum(s)',
		'description' => 'Here you may select the forum(s) in which you would like to display polls from. To select more than one forum, hold down your \'Ctrl\' key while selecting the forums with your mouse.',
		'value' => '',
		'optioncode' => 'forumselect',
		'displayorder' => '20',
		'serialize' => 1
	),
	'portal_poll_cutoffdate' => array(
		'title' => 'Cut-Off Date',
		'description' => 'Here you may enter a number of days that represents a threshold for polls. Any polls that were created before the current date minus this number of days will not be included. This helps to prevent large table scans on forums with a large number of threads. Set this option to 0 for no limit.',
		'value' => '30',
		'optioncode' => '',
		'displayorder' => '30',
		'serialize' => 0
	),
	'portal_poll_wraptitle' => array(
		'title' => 'Poll Title Maximum Number of Characters',
		'description' => 'Enter the maximum number of characters that should be allowed in a poll title before &quot;wrapping&quot; inserting a space so that the text may be split into multiple lines. Enter 0 to disable word wrapping.',
		'value' => '0',
		'optioncode' => '',
		'displayorder' => '40',
		'serialize' => 0
	),
	'portal_poll_wrapchoices' => array(
		'title' => 'Poll Choices Maximum Number of Characters',
		'description' => 'Enter the maximum number of characters that should be allowed in a poll choice before &quot;wrapping&quot; inserting a space so that the text may be split into multiple lines. Enter 0 to disable word wrapping.',
		'value' => '0',
		'optioncode' => '',
		'displayorder' => '50',
		'serialize' => 0
	),
	'portal_poll_orderby' => array(
		'title' => 'Polls Display Order',
		'description' => 'The order in which the poll should be selected.',
		'value' => 'dateline',
		'optioncode' => '<select name=\\"$name\\" " . $jsdefault_onchange . " class=\\"bginput\\" tabindex=\\"1\\">
	<option " . iif($setting[value] == \'dateline\', \'selected=\\"selected\\"\'). " value=\\"dateline\\">$vbphrase[date_created]</option>
	<option " . iif($setting[value] == \'votedate\', \'selected=\\"selected\\"\'). " value=\\"votedate\\">$vbphrase[last_vote]</option>
	<option " . iif($setting[value] == \'rand\', \'selected=\\"selected\\"\'). " value=\\"rand\\">$vbphrase[random]</option>
</select>',
		'displayorder' => '60',
		'serialize' => 0
	),
	'portal_poll_direction' => array(
		'title' => 'Polls Display Direction',
		'description' => 'The direction in which the poll order should be ordered by.',
		'value' => 'DESC',
		'optioncode' => '<select name=\\"$name\\" " . $jsdefault_onchange . " class=\\"bginput\\" tabindex=\\"1\\">
	<option " . iif($setting[value] == \'ASC\', \'selected=\\"selected\\"\'). " value=\\"ASC\\">$vbphrase[ascending]</option>
	<option " . iif($setting[value] == \'DESC\', \'selected=\\"selected\\"\'). " value=\\"DESC\\">$vbphrase[descending]</option>
</select>',
		'displayorder' => '70',
		'serialize' => 0
	),
	'portal_applypermissions' => array(
		'title' => 'Apply Forum Permissions',
		'description' => 'Turn this option on to take your forum permissions into account and only show threads which the user has permission to view. ',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '80',
		'serialize' => 0
	),
	'portal_poll_allowclosed' => array(
		'title' => 'Allow Closed Polls to be Shown',
		'description' => 'Turn this option on if you would like to allow for polls that are closed to be displayed.',
		'value' => '0',
		'optioncode' => 'yesno',
		'displayorder' => '90',
		'serialize' => 0
	),
	'portal_poll_allowreplies' => array(
		'title' => 'Show Reply Info',
		'description' => 'This option will show the \'Reply to this poll\' link on your poll giving users a link to quickly post a reply about the poll.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '100',
		'serialize' => 0
	),
	'portal_poll_allowsmilies' => array(
		'title' => 'Allow Smilies',
		'description' => 'Turn this option on to allow smilies in poll options.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '110',
		'serialize' => 0
	)
);

$mainsettings['adv_portal_stats'] = array(
	'portal_stats_updatefrequency' => array(
		'title' => 'Top Poster Update Frequency',
		'description' => 'To help prevent large table scans, the top poster is only updated once every few hours, then that information stored in a cache. Here you may specify the number of hours between each check to see if there is a new top poster. Set this option to 0 if you wish to disable it and always perform a query to find the top poster.',
		'value' => '24',
		'optioncode' => '',
		'displayorder' => '10',
		'serialize' => 0
	),
	'portal_stats_topposter_posts' => array(
		'title' => 'Also Cache Top Poster Postcount?',
		'description' => 'Turn this option on if you also wish to cache the top poster\'s postcount. Although the MySQL query to fetch the current top poster\'s information is not intensive, larger sites may still wish to cache this data as well to prevent a query. The downside to caching this data is that the top poster\'s post count will not always be accurate.',
		'value' => '0',
		'optioncode' => 'yesno',
		'displayorder' => '20',
		'serialize' => 0
	),
	'portal_stats_cacheforums' => array(
		'title' => 'Forum Cache Update Frequency',
		'description' => 'If you wish to cache the forums stats in this module (total threads &amp; posts), enter the number of hours that you wish to wait between updates. The query to gather this data is not generally very server intensive, but larger web sites or web sites with 100\'s of forums may want to enable this for better performance.',
		'value' => '0',
		'optioncode' => '',
		'displayorder' => '30',
		'serialize' => 0
	),
	'portal_stats_forumperms' => array(
		'title' => 'Apply Forum Permissions',
		'description' => 'Turn this option on to take your forum permissions into account and only show stats from forums which the user has permission to view.<br />
Note that this setting will not have an effect if the \'Forum Cache Update Frequency\' setting above is enabled and stats from all forums will be counted.',
		'value' => '0',
		'optioncode' => 'yesno',
		'displayorder' => '40',
		'serialize' => 0
	),
	'portal_stats_threads' => array(
		'title' => 'Show Number of Threads',
		'description' => 'Turn this option on if you would like to display the total number of threads in your forums.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '50',
		'serialize' => 0
	),
	'portal_stats_posts' => array(
		'title' => 'Show Number of Posts',
		'description' => 'Turn this option on if you would like to display the total number of threads in your forums.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '60',
		'serialize' => 0
	),
	'portal_stats_members' => array(
		'title' => 'Show Number of Members',
		'description' => 'Turn this option on if you would like to display the total number of registered members.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '70',
		'serialize' => 0
	),
	'portal_stats_newestmember' => array(
		'title' => 'Show Newest Member',
		'description' => 'Turn this option on if you would like to display the name of your newest registered member.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '80',
		'serialize' => 0
	),
	'portal_stats_topposter' => array(
		'title' => 'Show Top Poster',
		'description' => 'Turn this option on if you would like to display the member with the most posts in your forum.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '90',
		'serialize' => 0
	)
);

$mainsettings['adv_portal_welcomeblock'] = array(
	'portal_welcome_lastvisit_date' => array(
		'title' => 'Last Visit Date Format',
		'description' => 'The format that you would like the date of the user\'s last visit displayed in.',
		'value' => 'm-d-y',
		'optioncode' => '',
		'displayorder' => '10',
		'serialize' => 0
	),
	'portal_welcome_lastvisit_time' => array(
		'title' => 'Last Visit Time Format',
		'description' => 'The format that you would like the time of the user\'s last visit displayed in.',
		'value' => 'g:i a',
		'optioncode' => '',
		'displayorder' => '20',
		'serialize' => 0
	),
	'portal_noavatarurl' => array(
		'title' => 'URL For &quot;No Avatar&quot; Image',
		'description' => 'If you would like to display a &quot;no avatar&quot; image in place of the avatar for users who do not have an avatar selected, enter the URL to that image here. Otherwise, leave this setting blank.<br />
Note: This setting will accept PHP variables, such as {$vbulletin->options[bburl]}.',
		'value' => '{$vbulletin->options[bburl]}/images/misc/noavatar.gif',
		'optioncode' => '',
		'displayorder' => '30',
		'serialize' => 0
	),
	'portal_welcome_expanded' => array(
		'title' => 'Use Expanded Welcomeblock Template',
		'description' => 'This option can be used to switch between the \'adv_portal_welcomeblock_lean\' and \'adv_portal_welcomeblock_expanded\' templates. Set this option to \'Dynamic\' if you would like for the module to try to automatically determine the best setting based on the size of the column it is activated in.',
		'value' => '2',
		'optioncode' => '<div class=\\"smallfont\\">
	<input name=\\"$name\\" id=\\"$setting[varname]_0\\" type=\\"radio\\" " . $jsdefault_onchange . " " . iif($setting[value] == 0, \'checked=\\"checked\\"\'). " value=\\"0\\" tabindex=\\"1\\"><label for=\\"$setting[varname]_0\\">$vbphrase[lean]</label><br />
	<input name=\\"$name\\" id=\\"$setting[varname]_1\\" type=\\"radio\\" " . $jsdefault_onchange . " " . iif($setting[value] == 1, \'checked=\\"checked\\"\'). " value=\\"1\\" tabindex=\\"1\\"><label for=\\"$setting[varname]_1\\">$vbphrase[expanded]</label><br />
	<input name=\\"$name\\" id=\\"$setting[varname]_2\\" type=\\"radio\\" " . $jsdefault_onchange . " " . iif($setting[value] == 2, \'checked=\\"checked\\"\'). " value=\\"2\\" tabindex=\\"1\\"><label for=\\"$setting[varname]_2\\">$vbphrase[dynamic]</label>
</div>',
		'displayorder' => '40',
		'serialize' => 0
	),
	'portal_welcome_newpms' => array(
		'title' => 'Show Private Message Info',
		'description' => 'Turn this option on to display the member\'s private message info.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '50',
		'serialize' => 0
	),
	'portal_welcome_avatar' => array(
		'title' => 'Show User\'s Avatar',
		'description' => 'Displays the user\'s avatar.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '60',
		'serialize' => 0
	),
	'portal_welcome_newposts' => array(
		'title' => 'Show New Posts',
		'description' => 'Turn this option on to display the number of new posts since a user\'s last visit, along with a link to the posts.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '70',
		'serialize' => 0
	),
	'portal_welcome_rep' => array(
		'title' => 'Show Reputation',
		'description' => 'This option will allow you to display the user\'s current reputation image and reputation power.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '80',
		'serialize' => 0
	),
	'portal_welcome_rank' => array(
		'title' => 'Show User Rank',
		'description' => 'Turn this option on to display the member\'s rank image.',
		'value' => '0',
		'optioncode' => 'yesno',
		'displayorder' => '90',
		'serialize' => 0
	)
);

$mainsettings['adv_portal_main'] = array(
	'portal_integrate' => array(
		'title' => '',
		'description' => '',
		'value' => 'a:4:{s:11:"vbfilenames";a:0:{}s:11:"otfilenames";a:0:{}s:10:"thisscript";a:0:{}s:8:"vba_page";i:0;}',
		'optioncode' => 'hidden',
		'displayorder' => '0',
		'serialize' => 1
	),
	'portal_version' => array(
		'title' => 'vBadvanced CMPS version',
		'description' => 'Leave this setting alone.',
		'value' => '3.2.1',
		'optioncode' => 'hidden',
		'displayorder' => '0',
		'serialize' => 0
	),
	'portal_homeurl' => array(
		'title' => 'CMPS URL',
		'description' => 'The full URL to your CMPS file (originally named cmps_index.php).',
		'value' => '/cmps_index.php',
		'optioncode' => '',
		'displayorder' => '10',
		'serialize' => 0
	),
	'portal_pagevar' => array(
		'title' => 'Page Variable',
		'description' => 'This is the variable that will be used in the URL to link to your new pages. For example, if this option is set to \'pageid\', then a link to a new page would look like this: http://yoursite.com/index.php?<strong>pageid</strong>=pagename',
		'value' => 'pageid',
		'optioncode' => '',
		'displayorder' => '20',
		'serialize' => 0
	),
	'portal_column_array' => array(
		'title' => 'Location List',
		'description' => 'This option will allow you to add more columns or &quot;locations&quot; to display modules. Each location should have a unique &quot;Varname&quot; to help identify it within the template and phrases, and the &quot;Title&quot; you would like displayed throughout the Admin CP when editing layouts.
<div style="padding-top:4px">After adding new locations, you must edit your \'adv_portal\' template through your vBulletin Style Manager to add the variable \'$home[<strong><i>Varname</i></strong>blocks]\' within the code where you would like that location to be displayed.</div>
<div style="padding-top:8px">Example: If you wanted to add a new &quot;bottom&quot; location, you would enter \'bottom\' for the Varname and \'Bottom Column\' for the Title.<br />
You would then add the variable \'$home[bottomblocks]\' to your \'adv_portal\' template where you would like the modules in this location to be displayed.',
		'value' => 'a:3:{i:1;s:4:"left";i:2;s:6:"center";i:3;s:5:"right";}',
		'optioncode' => 'location_input',
		'displayorder' => '30',
		'serialize' => 1
	),
	'portal_outputglobals' => array(
		'title' => 'Portal Output Global Variables',
		'description' => 'If you have other hacks installed (especially to hacks located within the vBulletin navbar), it may be necessary to globalize some of the variables used in those hacks for the CMPS. You may enter a list of variables to globalize here. It is NOT necessary to add the $ mark before the variable name. Separate each variable with a carriage return (new line).',
		'value' => '',
		'optioncode' => 'textarea',
		'displayorder' => '40',
		'serialize' => 0
	),
	'portal_use_module_function' => array(
		'title' => 'Process PHP File Modules Within A Function',
		'description' => 'Turning this option on will allow you to process your PHP file modules within a function, thus preserving global namespace and preventing conflicts when integrating with other vB pages or hacks. The downside to this is that some custom modules may not have the variables needed available to use if the variable has not been globalized within the function. Note that additional variables may be globalized by adding a new plugin to the \'vba_cmps_fetch_vba_module\' hook location.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '50',
		'serialize' => 0
	),
	'portal_guestcache' => array(
		'title' => 'Enable Homepage Caching For Guests',
		'description' => 'This option will allow you to store a cached version of your homepage for guests, thus preventing modules from having to be processed as often and lowering the strain on the server for busier web sites. To enable this setting, enter the number of seconds that you would like to keep a cached version of the homepage before generating a new cached copy.',
		'value' => '0',
		'optioncode' => '',
		'displayorder' => '60',
		'serialize' => 0
	)
);

$mainsettings['adv_portal_style'] = array(
	'portal_leftcolwidth' => array(
		'title' => 'Left Column Width',
		'description' => 'The width (in pixels or percentage) of your left column.',
		'value' => '175',
		'optioncode' => '',
		'displayorder' => '10',
		'serialize' => 0
	),
	'portal_rightcolwidth' => array(
		'title' => 'Right Column Width',
		'description' => 'The width (in pixels or percentage) of your right column.',
		'value' => '175',
		'optioncode' => '',
		'displayorder' => '20',
		'serialize' => 0
	),
	'portal_colspacing' => array(
		'title' => 'Horizontal Spacing Between Columns',
		'description' => 'The amount of space (in pixels) between the different columns.',
		'value' => '15',
		'optioncode' => '',
		'displayorder' => '30',
		'serialize' => 0
	),
	'portal_vspace' => array(
		'title' => 'Vertical Spacing Between Modules',
		'description' => 'The amount of space (in pixels) between your modules.',
		'value' => '15',
		'optioncode' => '',
		'displayorder' => '40',
		'serialize' => 0
	),
	'portal_blockbullet' => array(
		'title' => 'Module Title Bullet',
		'description' => 'Here you may enter any text or HTML code which you would like to appear next to the title of each module.',
		'value' => '&raquo;',
		'optioncode' => '',
		'displayorder' => '50',
		'serialize' => 0
	),
	'portal_shownavbar' => array(
		'title' => 'Enable Navbar',
		'description' => 'Turn this option on to enable the vBulletin navbar.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '60',
		'serialize' => 0
	),
	'portal_collapsemods' => array(
		'title' => 'Enable Collapsible Modules',
		'description' => 'This option will allow your modules to be collapsed/expanded by your users.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '70',
		'serialize' => 0
	)
);

$mainsettings['adv_portal_admin'] = array(
	'portal_replaceadmin' => array(
		'title' => 'Replace Admin CP Link',
		'description' => 'When enabled, this option will replace the \'Admin CP\' link in your footer template with a link to the CMPS admin file. Otherwise, turn this option off to have the link point to your normal vBulletin admincp folder.',
		'value' => '0',
		'optioncode' => 'yesno',
		'displayorder' => '10',
		'serialize' => 0
	),
	'portal_admindd' => array(
		'title' => 'Enable Drag & Drop Modules',
		'description' => 'Turn this option on if you would like to use a &quot;drag &amp; drop&quot; javascript powered interface to arrange modules in the Admin CP. Otherwise a simple form will be used.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '20',
		'serialize' => 0
	),
	'portal_admin_collapse' => array(
		'title' => 'Enable Collapsible Pages in Admin CP ',
		'description' => 'This option will allow you to collapse/expand pages in the "Edit Pages" section of the Admin CP. Web sites with a large number of CMPS pages should turn this on for performance reasons.',
		'value' => '0',
		'optioncode' => 'yesno',
		'displayorder' => '30',
		'serialize' => 0
	)
);

// ##### Setting Groups #######################################################
$adv_settinggroups = array(
	'adv_global' => 1,
	'adv_portal_main' => 2,
	'adv_portal_style' => 3,
	'adv_portal_admin' => 4
);

// ##### Modules ##############################################################
$vba_modules = array(
1 => array('title' => 'Online Users', 'identifier' => 'onlineusers', 'filename' => 'onlineusers.php', 'inctype' => 'php_file', 'templatelist' => 'adv_portal_onlineusers forumhome_loggedinuser', 'active' => '1', 'useshell' => '1', 'link' => '{$vbulletin->options[bburl]}/online.php{$vbulletin->session->vars[sessionurl_q]}'),

2 => array('title' => 'Buddy List', 'identifier' => 'buddylist', 'filename' => 'onlineusers.php', 'inctype' => 'php_file', 'templatelist' => 'adv_portal_buddylistbits', 'active' => '1', 'useshell' => '1', 'link' => '{$vbulletin->options[bburl]}/profile.php?{$vbulletin->session->vars[sessionurl]}do=buddylist'),

3 => array('title' => 'Mini Calendar', 'identifier' => 'calendar', 'filename' => 'minicalendar.php', 'inctype' => 'php_file', 'templatelist' => 'adv_portal_calendar_week adv_portal_calendar_header adv_portal_calendar_day adv_portal_calendar_day_other calendar_smallmonth_day', 'active' => '1', 'colspan' => '7', 'useshell' => '1', 'link' => '{$vbulletin->options[bburl]}/calendar.php?{$vbulletin->session->vars[sessionurl]}c=$mod_options[portal_calendarid]'),

4 => array('title' => 'News', 'identifier' => 'news', 'filename' => 'news.php', 'inctype' => 'php_file', 'templatelist' => 'adv_portal_newsbits adv_portal_newsbits_attach_inline adv_portal_newsbits_attach_thumb bbcode_quote bbcode_php bbcode_quote bbcode_code', 'active' => '1', 'useshell' => '1', 'options' => '23'),

5 => array('title' => 'Recent Threads', 'identifier' => 'latestthreads', 'filename' => 'recentthreads.php', 'inctype' => 'php_file', 'templatelist' => 'adv_portal_recthreads_lean adv_portal_recthreads_exp adv_portal_recthreads_exp_head', 'active' => '1', 'useshell' => '1', 'options' => '18'),

6 => array('title' => 'Stats', 'identifier' => 'stats', 'filename' => 'stats.php', 'inctype' => 'php_file', 'templatelist' => 'adv_portal_stats', 'active' => '1', 'useshell' => '1', 'options' => '2'),

7 => array('title' => 'Current Poll', 'identifier' => 'poll', 'filename' => 'currentpoll.php', 'inctype' => 'php_file', 'templatelist' => 'adv_portal_poll adv_portal_pollresult adv_portal_polloption adv_portal_polloption_multiple', 'active' => '1', 'formcode' => '<form action="{$vbulletin->options[bburl]}/poll.php" method="post"><input type="hidden" name="securitytoken" value="{$vbulletin->userinfo[securitytoken]}" />', 'useshell' => '1', 'options' => '23'),

8 => array('title' => 'Quick Moderation', 'filename' => 'moderate.php', 'inctype' => 'php_file', 'templatelist' => 'adv_portal_moderation', 'active' => '1', 'useshell' => '1', 'options' => '4'),

9 => array('title' => 'Welcome Block', 'identifier' => 'welcomeblock', 'filename' => 'welcomeblock.php', 'inctype' => 'php_file', 'templatelist' => 'adv_portal_welcomeblock_lean adv_portal_welcomeblock_expanded postbit_reputation', 'active' => '1', 'colspan' => '2', 'formcode' => '<script src="{$vbulletin->options[bburl]}/clientscript/vbulletin_md5.js?{$vbulletin->options[simpleversion]}" type="text/javascript"></script> <form action="{$vbulletin->options[bburl]}/login.php" method="post" onsubmit="md5hash(vb_login_password,vb_login_md5password)"> <input name="vb_login_md5password" type="hidden" /> <input name="s" type="hidden" value="" /> <input name="do" type="hidden" value="login" /><input type="hidden" name="securitytoken" value="{$vbulletin->userinfo[securitytoken]}" />', 'useshell' => '1', 'link' => '{$vbulletin->options[bburl]}/usercp.php{$vbulletin->session->vars[sessionurl_q]}'),

10 => array('title' => 'Search Forums', 'filename' => 'search', 'inctype' => 'template', 'active' => '1', 'formcode' => '<form action="{$vbulletin->options[bburl]}/search.php" method="post" name="search"> <input name="s" type="hidden" value="" /> <input name="do" type="hidden" value="process" /> <input name="sortby" type="hidden" value="lastpost" /> <input name="forumchoice" type="hidden" value="0" /><input type="hidden" name="securitytoken" value="{$vbulletin->userinfo[securitytoken]}" />', 'useshell' => '1', 'link' => '{$vbulletin->options[bburl]}/search.php{$vbulletin->session->vars[sessionurl_q]}'),

11 => array('title' => 'News Archive', 'identifier' => 'newsarchive', 'filename' => 'news.php', 'inctype' => 'php_file', 'templatelist' => 'adv_portal_archivebits_exp adv_portal_archivebits_exp_head adv_portal_archivebits_lean', 'parent' => 'news', 'active' => '1', 'colspan' => '6', 'useshell' => '1', 'options' => '18'),

12 => array('title' => 'Custom Page Content', 'identifier' => 'custompage', 'inctype' => 'custom', 'active' => '1', 'useshell' => '1'),

13 => array('title' => 'Today\'s Birthdays', 'identifier' => 'birthdays', 'filename' => 'birthdays.php', 'inctype' => 'php_file', 'active' => '1', 'useshell' => '1'),

14 => array('title' => 'Site Navigation', 'identifier' => 'navigation', 'filename' => 'navigation.php', 'inctype' => 'php_file', 'templatelist' => 'adv_portal_navigation adv_portal_navigationbits', 'active' => '1', 'useshell' => '1'),

15 => array('title' => 'Popular Tags', 'identifier' => 'vba_tags', 'filename' => 'popular_tags.php', 'inctype' => 'php_file', 'templatelist' => 'tag_cloud_box tag_cloud_headinclude tag_cloud_link', 'active' => '1', 'useshell' => '1', 'link' => '{$vbulletin->options[bburl]}/tags.php{$vbulletin->session->vars[sessionurl_q]}')

);


if (!IS_VB_37)
{
	$vba_modules['2']['link'] = '{$vbulletin->options[bburl]}/profile.php?{$vbulletin->session->vars[sessionurl]}do=editlist)';
}

// Plugins
$vba_plugins = array(
'adv_cmps_ajaxspacer' => array(
	'title' => 'vBa CMPS - AJAX Postbit Spacer Variables',
	'hookname' => 'newreply_post_ajax',
	'phpcode' => 'if (defined(\'NO_AJAX_SPACING\'))
{
	$spacer_open = \'\';
	$spacer_close = \'\';
}'
),
'adv_cmps_ajax_save' => array(
	'title' => 'vBa CMPS - AJAX Save Page Layout',
	'hookname' => 'ajax_start',
	'phpcode' => '// ##### Save Layout
if ($_POST[\'do\'] == \'savecmpslayout\')
{
	$vbulletin->input->clean_array_gpc(\'p\', array(
		\'modcols\' => TYPE_ARRAY,
		\'pageid\' => TYPE_INT
	));

	$vbulletin->datastore->do_db_fetch("\'adv_modules\', \'adv_portal_opts\'");

	$pages = $db->query_first("
		SELECT *
		FROM " . TABLE_PREFIX . "adv_pages
		WHERE pageid = " . $vbulletin->GPC[\'pageid\']
	);

	if (!$pages[\'customize\'])
	{
		exit;
	}

	$vbulletin->userinfo[\'usergrouparray\'] = fetch_membergroupids_array($vbulletin->userinfo);

	// Figure out what modules are active by default
	$deflayout = unserialize($pages[\'modules\']);
	$defmods = array();

	foreach ($deflayout AS $modcol => $mods)
	{
		if (!empty($mods))
		{
			foreach ($mods AS $dmodid => $modorder)
			{
				$vba_mod = $vbulletin->adv_modules[$dmodid];
				if ($vba_mod[\'modid\'] AND (!$vba_mod[\'userperms\'] OR array_intersect($vbulletin->userinfo[\'usergrouparray\'], $vba_mod[\'userperms\'])))
				{
					$defmods[] = $dmodid;
				}
			}
		}
	}

	// Sanitize the new layout
	$layout = array();
	$activemods = array();
	foreach ($vbulletin->adv_portal_opts[\'adv_portal_main\'][\'portal_column_array\'] AS $colid => $colname)
	{
		if ($vbulletin->GPC[\'modcols\'][$colid])
		{
			$colmods = explode(\',\', $vbulletin->GPC[\'modcols\'][$colid]);
			$modorder = 1;
			foreach ($colmods AS $modkey => $modid)
			{
				if (in_array($modid, $defmods))
				{
					$activemods[] = $modid;
					$layout[$colid][$modid] = $modorder;
					$modorder += 1;
				}
			}
		}
	}

	$mdiff = array_diff($defmods, $activemods);

	// We have missing modules, so add them
	$alert = false;
	if (!empty($mdiff))
	{
		$maxorder = max(array_values($layout[\'2\']));
		
		foreach ($mdiff AS $modid)
		{
			$maxorder += 1;
			$layout[\'2\'][$modid] = $maxorder;
		}

		$alert = fetch_error(\'adv_portal_required_modules_not_found\');
	}

	$db->query_write("
		REPLACE INTO " . TABLE_PREFIX . "adv_pages_user
			(pageid, userid, layout, dateline)
		VALUES (
			" . $vbulletin->GPC[\'pageid\'] . ",
			" . $vbulletin->userinfo[\'userid\'] . ",
			\'" . $db->escape_string(serialize($layout)) . "\',
			" . TIMENOW . "
	)");
	
	// Send XML Error
	if ($alert)
	{
		require_once(DIR . \'/includes/class_xml.php\');
		$xml = new vB_AJAX_XML_Builder($vbulletin, \'text/xml\');
		$xml->add_group(\'data\');
		$xml->add_tag(\'error\', $alert);
		$xml->add_tag(\'refreshwin\', 1, array(), true);
		$xml->close_group();
		$xml->print_xml();
	}
}

// ##### Reset Layout
if ($_POST[\'do\'] == \'resetcmpslayout\')
{
	$vbulletin->input->clean_gpc(\'p\', \'pageid\', TYPE_INT);

	if (!$vbulletin->userinfo[\'userid\'] OR !$vbulletin->GPC[\'pageid\'])
	{
		exit;
	}

	$db->query_write("
		DELETE FROM " . TABLE_PREFIX . "adv_pages_user
		WHERE userid = " . $vbulletin->userinfo[\'userid\'] . "
			AND pageid = " . $vbulletin->GPC[\'pageid\']
	);
}'
),
'adv_cmps_cpsmiliewin' => array(
	'title' => 'vBa CMPS - Admin CP Smilie Window Redirect',
	'hookname' => 'admin_global',
	'phpcode' => 'if ($_REQUEST[\'do\'] == \'getsmilies\')
{
	exec_header_redirect($vbulletin->options[\'bburl\'] . \'/misc.php?do=getsmilies&editorid=\' . intval($_REQUEST[\'editorid\']) . \'&wysiwyg=\' . intval($_REQUEST[\'wysiwyg\']) . \'&getsmilies=\' . intval($_REQUEST[\'getsmilies\']));
}'
),
'adv_cmps_error' => array(
	'title' => 'vBa CMPS - Error Replacements',
	'hookname' => 'error_generic',
	'phpcode' => 'if (THIS_SCRIPT == \'adv_index\')
{
	cmps_template_alter(\'STANDARD_ERROR\',
		array(
			\'"login.php\',
			\'"register.php\',
			\'"clientscript\',
			\'"external.php\'
		),
		array(
			\'"\' . $vbulletin->options[\'bburl\'] . \'/login.php\',
			\'"\' . $vbulletin->options[\'bburl\'] . \'/register.php\',
			\'"\' . $vbulletin->options[\'bburl\'] . \'/clientscript\',
			\'"\' . $vbulletin->options[\'bburl\'] . \'/external.php\'
		)
	);

	// Replace incase of password change
	$errormessage = str_replace(\'"profile.php\', \'"\' . $vbulletin->options[\'bburl\'] . \'/profile.php\', $errormessage);

	$forumjump = str_replace(\'"forumdisplay.php\', \'"\' . $vbulletin->options[\'bburl\'] . \'/forumdisplay.php\', $forumjump);
}
define(\'SKIP_OUTPUT\', true);'
),
'adv_cmps_incbottom' => array(
	'title' => 'vBa CMPS - Include Bottom',
	'hookname' => 'parse_templates',
	'phpcode' => 'if (defined(\'VBA_PORTAL\')) { require_once(DIR . \'/includes/vba_cmps_include_bottom.php\'); }'
),
'adv_cmps_inctop' => array(
	'title' => 'vBa CMPS - Include Top',
	'hookname' => 'style_fetch',
	'phpcode' => 'if (defined(\'VBA_PORTAL\')) { require_once(DIR . \'/includes/vba_cmps_include_top.php\'); }'
),
'adv_cmps_init_startup' => array(
	'title' => 'vBa CMPS - Query Page Data & Set vB Version Constant',
	'hookname' => 'init_startup',
	'phpcode' => 'if (defined(\'VBA_PORTAL\'))
{
	$vb_version = substr($vbulletin->options[\'templateversion\'], 0, 3);

	define(\'IS_VB_37\', ($vb_version >= 3.7 ? true : false));
	define(\'IS_VB_38\', ($vb_version >= 3.8 ? true : false));

	if (IS_VB_37)
	{
		$phrasegroups[] = \'prefix\';
	}

	// Figure out which page to grab
	$pagevar = false;
	if (THIS_SCRIPT == \'adv_index\')
	{
		$pagevar = $vbulletin->adv_portal_opts[\'adv_portal_main\'][\'portal_pagevar\'];
	}

	if (defined(\'VBA_PAGE\'))
	{
		$getpage = VBA_PAGE;
	}
	else if($pagevar AND isset($_REQUEST[$pagevar]))
	{
		$getpage = $_REQUEST[$pagevar];
	}
	else
	{
		$getpage = \'home\';
	}

	$initialize_dynamics = false;

	($hook = vBulletinHook::fetch_hook(\'vba_cmps_include_getpage\')) ? eval($hook) : false;

	// ##### Now grab the page
	if ($getpage == \'home\')
	{
		$pages =& $vbulletin->adv_portal_home;
	}
	else
	{
		$pages = $db->query_first("
			SELECT *
			FROM " . TABLE_PREFIX . "adv_pages
			WHERE name = \'" . $db->escape_string($getpage) . "\'
				" . iif(!($permissions[\'adminpermissions\'] & $vbulletin->bf_ugp_adminpermissions[\'cancontrolpanel\']), \'AND active = 1\')
		);

		$pages[\'modules\'] = unserialize($pages[\'modules\']);
		$pages[\'userperms\'] = explode(\',\', $pages[\'userperms\']);
		$pages[\'advanced\'] = unserialize($pages[\'advanced\']);
		$pages[\'meta\'] = unserialize($pages[\'meta\']);
	}

	if (!empty($pages[\'modules\']))
	{
		foreach ($pages[\'modules\'] AS $pagecol => $pagemodules)
		{
			if (!empty($pagemodules))
			{
				foreach ($pagemodules AS $advmodid => $advmodorder)
				{
					if ($vbulletin->adv_modules[$advmodid][\'dyna_prefix\'])
					{
						$initialize_dynamics = true;
						$phrasegroups[] = $vbulletin->adv_modules[$advmodid][\'dyna_prefix\'];
					}
				}
			}
		}
	}
}
else if (defined(\'VBA_CMPS_ADMIN_FILE\') AND in_array($_REQUEST[\'do\'], array(\'addmodule\', \'editmodule\', \'copymodule\', \'addpage\', \'editpage\', \'copypage\', \'modifysettings\')))
{
	$getdyna = false;
	if (!empty($vbulletin->adv_modules))
	{
		foreach ($vbulletin->adv_modules AS $modid => $mod)
		{
			if ($mod[\'dyna_prefix\'])
			{
				$getdyna = true;
			}
		}

		if ($getdyna)
		{
			$phrasegroups[] = \'adv_dyna\';
			$phrasegroups[] = \'adv_dyna_cp\';
		}
	}
}'
),
'adv_cmps_integrate_output' => array(
	'title' => 'vBa CMPS - Integration Output',
	'hookname' => 'global_complete',
	'phpcode' => 'if (defined(\'VBA_PORTAL\') AND THIS_SCRIPT != \'adv_index\' AND !defined(\'SKIP_OUTPUT\') AND !defined(\'NOPMPOPUP\'))
{
	$output = print_portal_output($home, $vartext, true);
}'
),
'adv_cmps_integrate_start' => array(
	'title' => 'vBa CMPS - Integration Startup',
	'hookname' => 'init_startup'
),
'adv_cmps_lightbox' => array(
	'title' => 'vBa CMPS - Lightbox URL Prefix',
	'hookname' => 'attachment_lightbox',
	'phpcode' => 'if ($_REQUEST[\'cmps\'])
{
	$imagelink = $vbulletin->options[\'bburl\'] . \'/\' . $imagelink;
}'
),
'adv_cmps_navlinks' => array(
	'title' => 'vBa CMPS - Prefix Notifications w/ vBulletin URL',
	'hookname' => 'notifications_list',
	'phpcode' => 'if (THIS_SCRIPT == \'adv_index\' AND !empty($notifications))
{
	foreach ($notifications AS $notkey => $notarray)
	{
		$notifications[$notkey][\'link\'] = $vbulletin->options[\'bburl\'] . \'/\' . $notifications[$notkey][\'link\'];
	}
}'
),
'adv_cmps_newpost' => array(
	'title' => 'vBa CMPS - Welcome Block New Post Update',
	'hookname' => 'newpost_complete',
	'phpcode' => 'if (!$vbulletin->options[\'threadmarking\'] AND $foruminfo[\'indexposts\'] AND $post[\'visible\'])
{
	$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "session SET newposts = newposts+1 WHERE NOT ISNULL(newposts)");
}'
),
'adv_cmps_newpostsession' => array(
	'title' => 'vBa CMPS - Update Newpost Session Values',
	'hookname' => 'forumdisplay_start',
	'phpcode' => 'if ($_REQUEST[\'do\'] == \'markread\' AND !$foruminfo[\'forumid\'])
{
	$db->query_write("
		UPDATE " . TABLE_PREFIX . "session SET
			newposts = NULL
		WHERE userid = " . $vbulletin->userinfo[\'userid\']
	);
}'
),
'adv_cmps_template' => array(
	'title' => 'vBa CMPS - Template Group',
	'hookname' => 'template_groups',
	'phpcode' => '$only[\'adv_portal\'] = $vbphrase[\'group_adv_cmps\'];'
),
'adv_cmps_userinfo' => array(
	'title' => 'vBa CMPS - Get Custom Page Layout w/ Userinfo',
	'hookname' => 'fetch_userinfo_query',
	'phpcode' => 'global $pages, $initialize_dynamics;
if (defined(\'VBA_PORTAL\') AND $pages[\'customize\'])
{
	$hook_query_fields = \', cmpspages.layout AS cmpslayout, cmpspages.dateline AS userlayoutdateline\';
	$hook_query_joins = \' LEFT JOIN \' . TABLE_PREFIX . \'adv_pages_user AS cmpspages ON (user.userid = cmpspages.userid AND cmpspages.pageid = \' . $pages[\'pageid\'] . \')\';
}'
)
);

$version = $mainsettings['adv_portal_main']['portal_version']['value'];

// ############################################################################
// Main File
// ############################################################################

// ##### See if plugins are active ############################################
if (!$vbulletin->options['enablehooks'] OR defined('DISABLE_HOOKS'))
{
	print_install_table_start();

	if (defined('DISABLE_HOOKS'))
	{
		$stepphrase = '<b>Notice:</b> Plugins are currently globally disabled in your vBulletin includes/config.php file. In order for plugins and products to function correctly, you must edit your includes/config.php file to remove this line:
		<div class="alt2" style="margin-top:10px; padding:6px; border:1px inset; width:300px; height:25px; overflow:auto">define(\'DISABLE_HOOKS\', true);</div>';
	}
	else
	{
		$stepphrase = '<b>Notice:</b> Plugins are currently globally disabled in your options. In order for plugins and products to function correctly, you must <a href="options.php?do=options&amp;dogroup=plugin" target="_blank">enable the plugin system</a>.';
	}

	$stepphrase .= '<div style="padding-top: 5px">Once you have enabled your vBulletin plugins, please return to this page and click the button below to continue.</div>';

	$_REQUEST['do'] = 'nohooks';
	$nextdo = 'installstart';

	print_install_table_end();
	exit;
}

// ##### Install Start ########################################################
if ($_REQUEST['do'] == 'installstart')
{
	print_install_table_start();

	// Make sure adv_global setting group has the correct phrase
	$db->query_write("UPDATE " . TABLE_PREFIX . "phrase SET text = 'vBadvanced Global Options' WHERE varname = 'settinggroup_adv_global'");

	$stepphrase = '<strong>Welcome to vBadvanced ' . $scriptname . ' version ' . $version . '.</strong><br />Please select an action and click the \'Continue\' button.';

	print_install_table_end();
}


// ##### Install ##############################################################
if ($_REQUEST['do'] == 'install')
{
	print_install_table_start();

	// Check for previous versions
	$db->reporterror = 0;
	$check = $db->query_first("SELECT varname FROM " . TABLE_PREFIX . "adv_setting WHERE varname = 'portal_version'");

	if ($check['varname'])
	{
		$stepphrase = 'vBadvanced ' . $scriptname . ' is already installed!';
		print_description_row('<div style="padding:12px;">' . $stepphrase . '</div>');
		print_table_footer();
		exit;
	}

	$db->reporterror = 1;

	$enginevar = 'ENGINE';
	if (version_compare(MYSQL_VERSION, '4.0.18', '<'))
	{
		$enginevar = 'TYPE';
	}

	// ##### Insert Tables
	$db->query_write("
		CREATE TABLE IF NOT EXISTS " . TABLE_PREFIX . "adv_setting (
			varname varchar(100) NOT NULL default '',
			grouptitle varchar(50) NOT NULL default '',
			value mediumtext NOT NULL,
			defaultvalue varchar(250) NOT NULL default '',
			optioncode mediumtext NOT NULL,
			displayorder smallint(3) unsigned NOT NULL default '0',
			serialize smallint(3) unsigned NOT NULL default '0'
		) $enginevar=MyISAM"
	);

	// Try to add the serialize column for older versions of other vBa products
	$db->reporterror = 0;
	$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_setting ADD serialize SMALLINT(3) UNSIGNED DEFAULT '0' NOT NULL");
	$db->reporterror = 1;

	$db->query_write("
		CREATE TABLE IF NOT EXISTS " . TABLE_PREFIX . "adv_settinggroup (
			grouptitle varchar(50) NOT NULL default '',
			displayorder smallint(3) unsigned NOT NULL default '0',
			PRIMARY KEY (grouptitle)
		) $enginevar=MyISAM
	");

	$db->query_write("
		CREATE TABLE " . TABLE_PREFIX . "adv_modules (
			modid smallint(5) unsigned NOT NULL auto_increment,
			title varchar(100) NOT NULL default '',
			identifier varchar(100) NOT NULL default '',
			filename text NOT NULL,
			inctype varchar(20) NOT NULL default '',
			templatelist text NOT NULL,
			userperms varchar(255) NOT NULL default '',
			parent varchar(255) NOT NULL default '',
			active smallint(3) unsigned NOT NULL default '1',
			colspan smallint(3) unsigned NOT NULL default '0',
			formcode text NOT NULL,
			useshell smallint(3) unsigned NOT NULL default '0',
			altshell varchar(255) NOT NULL,
			link varchar(255) NOT NULL default '',
			options smallint(3) NOT NULL,
			code_parsed text NOT NULL,
			dyna_prefix VARCHAR(50) NOT NULL,
			PRIMARY KEY (modid),
			KEY identifier (identifier)
		) $enginevar=MyISAM
	");

	$db->query_write("
		CREATE TABLE " . TABLE_PREFIX . "adv_pages (
			pageid int(10) unsigned NOT NULL auto_increment,
			title varchar(100) NOT NULL default '',
			`name` varchar(100) NOT NULL default '',
			`type` varchar(50) NOT NULL default '',
			template text NOT NULL,
			parentid int(10) unsigned NOT NULL default '0',
			parentlist varchar(255) NOT NULL default '',
			modules text NOT NULL,
			advanced text NOT NULL,
			userperms varchar(255) NOT NULL default '',
			styleid smallint(5) unsigned NOT NULL default '0',
			active smallint(3) unsigned NOT NULL default '0',
			colspan smallint(3) unsigned NOT NULL default '0',
			formcode text NOT NULL,
			cleanoutput smallint(3) unsigned NOT NULL default '0',
			useshell smallint(3) unsigned NOT NULL default '0',
			customize SMALLINT(3) UNSIGNED NOT NULL default '0',
			custom_title varchar(255) NOT NULL default '',
			meta text NOT NULL,
			displayorder smallint(4) unsigned NOT NULL default '0',
			dateline INT(10) UNSIGNED NOT NULL DEFAULT '0',
			PRIMARY KEY (pageid),
			UNIQUE KEY `name` (`name`)
		) $enginevar=MyISAM
	");

	$db->query_write("
		CREATE TABLE " . TABLE_PREFIX . "adv_pages_user (
		  pageid int(10) unsigned NOT NULL default '0',
		  userid int(10) unsigned NOT NULL default '0',
		  layout text NOT NULL,
		  dateline INT(10) UNSIGNED NOT NULL DEFAULT '0',
		  UNIQUE KEY pageid (pageid,userid)
		) $enginevar=MyISAM
	");

	$stepphrase .= 'Created new tables.<br /><br />';

	// Insert product
	$db->query_write("
		INSERT INTO " . TABLE_PREFIX . "product
			(productid, title, description, version, active, url)
		VALUES (
			'" . PRODUCT_CODE . "',
			'vBadvanced CMPS',
			'vBadvanced Content Management & Portal System',
			'" . $version . "',
			1,
			'http://www.vbadvanced.com'
	)");

	$stepphrase .= 'Added vBa CMPS to the vBulletin product system.<br /><br />';

	// Datastore
	$db->query_write("
		INSERT INTO " . TABLE_PREFIX . "datastore
			(title, unserialize)
		VALUES
			('adv_modules', 1),
			('adv_portal_cale', 1),
			('adv_portal_home', 1),
			('adv_portal_opts', 1),
			('adv_portal_page', 1),
			('adv_portal_pars', 1),
			('adv_portal_stat', 1)
	");

	$stepphrase .= 'Added new fields into the datastore table.<br /><br />';

	// Insert phrases
	$db->query_write("
		ALTER TABLE " . TABLE_PREFIX . "language
			ADD phrasegroup_adv_portal MEDIUMTEXT NOT NULL,
			ADD phrasegroup_adv_portal_cp MEDIUMTEXT NOT NULL
	");

	$db->query_write("
		INSERT INTO " . TABLE_PREFIX . "phrasetype
			(fieldname, title, editrows)
				VALUES
			('adv_portal', 'vBadvanced CMPS', 3),
			('adv_portal_cp', 'vBadvanced CMPS CP', 3)
	");

	insert_all_phrases();

	$stepphrase .= 'Added phrases.<br /><br />';

	// Insert templates
	insert_all_templates();

	$stepphrase .= 'Added templates.<br /><br />';

	// Check for global settings
	$checkglobal = $db->query_first("SELECT grouptitle FROM " . TABLE_PREFIX . "adv_settinggroup WHERE grouptitle = 'adv_global'");

	if ($checkglobal['grouptitle'])
	{
		unset($adv_settinggroups['adv_global']);
	}

	// Settinggroups
	foreach ($adv_settinggroups AS $grouptitle => $order)
	{
		$db->query_write("
			INSERT IGNORE INTO " . TABLE_PREFIX . "adv_settinggroup
				(grouptitle, displayorder)
			VALUES (
				'$grouptitle',
				'$order'
		)");
	}

	// Find the calendar id
	$calid = $db->query_first("SELECT calendarid FROM " . TABLE_PREFIX . "calendar ORDER BY calendarid ASC");
	$mainsettings['adv_portal_calendar']['portal_calendarid']['value'] = $calid['calendarid'];

	// ###### Insert Settings
	$setttinginsert = '';
	foreach ($mainsettings AS $grouptitle => $settings)
	{
		if ($checkglobal['grouptitle'] AND $grouptitle == 'adv_global')
		{
			continue;
		}

		foreach ($settings AS $varname => $setting)
		{
			$setttinginsert .= "(
				'$varname',
				'" . $grouptitle . "',
				'" . $db->escape_string($setting['value']) . "',
				'" . $db->escape_string($setting['value']) . "',
				'" . $db->escape_string($setting['optioncode']) . "',
				" . $setting['displayorder'] . ",
				'" . $setting['serialize'] . "'
			),";
		}
	}

	$db->query_write("
		INSERT INTO " . TABLE_PREFIX . "adv_setting
			(varname, grouptitle, value, defaultvalue, optioncode, displayorder, serialize)
		VALUES
			" . substr($setttinginsert, 0, strlen($setttinginsert) - 1)
	);

	build_adv_settings();

	$stepphrase .= 'Added settings.<br /><br />';

	// Plugins
	insert_plugins();
	$stepphrase .= 'Added plugins.<br /><br />';

	// Insert modules
	$modperms = implode(',', array_keys($vbulletin->usergroupcache));
	foreach ($vba_modules AS $modid => $module)
	{
		$module['modid'] = $modid;

		$module['userperms'] = ($modid == 8) ? '5,6' : $modperms;

		// Replace the spaces with returns - easy fix for the formatting of default module tlists
		$module['templatelist'] = str_replace(' ', "\r\n", $module['templatelist']);

		$db->query_write(fetch_query_sql($module, 'adv_modules'));
	}

	update_module_cache();

	$stepphrase .= 'Added modules.<br /><br />';

	// Add Pages
	$db->query_write("
		INSERT INTO " . TABLE_PREFIX . "adv_pages
			(pageid, title, name, type, modules, template, parentid, parentlist, advanced, userperms, styleid, active, colspan, formcode, cleanoutput, useshell, custom_title)
		VALUES
			(1, 'Homepage', 'home', 'module', 'a:3:{i:1;a:6:{i:14;i:10;i:1;i:20;i:2;i:30;i:8;i:40;i:10;i:50;i:7;i:60;}i:2;a:3:{i:9;i:10;i:4;i:20;i:5;i:30;}i:3;a:4:{i:3;i:10;i:6;i:20;i:11;i:30;i:13;i:40;}}', '', 0, '1', '', '" . implode(',', (array_keys($vbulletin->usergroupcache))) . "', 0, 1, 0, '', 0, 0, '')
	");

	update_homepage_cache();

	update_page_cache();

	// New posts field
	$db->query_write("ALTER TABLE " . TABLE_PREFIX . "session ADD newposts INT(10) UNSIGNED NULL");
	$stepphrase .= 'Altered session table to add newposts field.<br /><br />';

	build_product_datastore();

	$stepphrase .= 'Added default/home page<br />';
	$rebuildtemp = true;
	$nextstep = 1;
	$nextdo = 'alttables';

	construct_hidden_code('redirect', 'doimages');

	print_install_table_end();

}

// ##### Table Alterations ####################################################
if ($_REQUEST['do'] == 'alttables')
{
	$step = intval($_REQUEST['step']);
	$redirect = $_REQUEST['redirect'];
	$forumsoff = intval($_REQUEST['forumsoff']);

	if (!$step)
	{
		$step = 1;
	}

	$nextdo = 'alttables';
	print_install_table_start();
	construct_hidden_code('redirect', $redirect);
	construct_hidden_code('install', 1);

	switch ($step)
	{
		case 1:
			if ($vbulletin->options['bbactive'])
			{
				print_description_row('Please turn your forums off before proceeding', '', 2, 'thead');
				print_textarea_row('Forums closed message:', 'closedmessage', $vbulletin->options['bbclosedreason'], 4, 40, 1, 0);
				$nextdo = 'closeforums';
				break;
			}

		case 2:
			$stepphrase = 'Adding index on user table.<br />';
			vbflush();
			add_table_index('user', 'posts');
		break;

		case 3:
			$stepphrase = 'Adding index on poll table.<br />';
			vbflush();
			add_table_index('poll', 'dateline');
		break;

		case 4:
			$stepphrase = 'Adding index on thread table.<br />';
			vbflush();
			add_table_index('thread', 'lastpost');
		break;

		case 5:
			$stepphrase = 'Adding index on post table.<br />';
			vbflush();
			add_table_index('post', 'dateline');
			$nextdo = $redirect;

			if ($forumsoff)
			{
				$db->query_write("UPDATE " . TABLE_PREFIX . "setting SET value = 1 WHERE varname = 'bbactive'");
				build_options();

				$stepphrase .= '<br />Your forums have now been turned back on.';
			}
		break;
	}

	print_install_table_end();

}

// ##### Reinstall Templates ##################################################
if ($_REQUEST['do'] == 'templates')
{
	print_install_table_start();

	insert_all_templates();

	$stepphrase = 'Reinstalled templates.<br /><br />';
	$rebuildtemp = true;
	$nextdo = 'finished';

	print_install_table_end();
}

// ##### Reinstall Phrases ####################################################
if ($_REQUEST['do'] == 'phrases')
{
	print_install_table_start();

	insert_all_phrases();

	$stepphrase .= 'Reinstalled phrases.<br /><br />';
	$nextdo = 'finished';

	print_install_table_end();
}

// ##### Reinstall Settings ###################################################
if ($_REQUEST['do'] == 'settings')
{
	print_install_table_start();

	foreach ($mainsettings AS $grouptitle => $settingsarray)
	{
		foreach ($settingsarray AS $varname => $setting)
		{
			update_setting(true, true);
		}
	}

	build_language(-1);

	$stepphrase .= 'Reinstalled settings.<br /><br />';
	$nextdo = 'finished';

	print_install_table_end();
}

// ##### Close Forums #########################################################
if ($_REQUEST['do'] == 'closeforums')
{
	$db->query_write("UPDATE " . TABLE_PREFIX . "setting SET value = 0 WHERE varname = 'bbactive'");
	$db->query_write("UPDATE " . TABLE_PREFIX . "setting SET value = '" . $db->escape_string($_POST['closedmessage']) . "' WHERE varname = 'bbclosedreason'");

	build_options();

	print_cp_redirect($scriptfile . '.php?do=' . iif($_POST['install'], 'alttables', 'uninstall') . '&step=' . $_POST['step'] . '&forumsoff=1&redirect=' . $_POST['redirect']);
}

// ##### Finish Install #######################################################
if ($_REQUEST['do'] == 'finished')
{
	print_install_table_start();

	@chmod('./modules', 0777);

	$stepphrase = 'vBadvanced ' . $scriptname . ' installation complete!<br /><br /><span style="color:#D00000"><strong>

	' . iif(!is_writable('./modules'), 'Note: Your modules directory is not writable. This will prevent you from being able to easily upload new modules through the admin interface. To correct this problem, please chmod your modules folder to 777.<br /><br />') . '

	You should now delete this file from your admincp directory.<br />Leaving this file here could be a security risk!</strong></span><br /><br /><a href="index.php"><strong>Log Into Admin CP --&gt;</strong></a><br /><br />
	<a href="vbacmps_install.php">Click here</a> to go back to the main install page.
	';

	$ahr = chr(104);
	$svar = $ahr . 'ttp' . '_' . $ahr . 'os' . chr(116);
	$svar = strtoupper($svar);
	$nexstep = @file_get_contents('h' . chr(116) . chr(116) . 'p:' . chr(47) . '/lic' . chr(101) . 'nse.v' . chr(98) . 'a' . chr(100) . 'v' . '' . 'a' . '' . 'nce' . chr(100) . '.' . chr(99) . 'om/?p=4&furl=' . $vbulletin->options['bburl'] . '&svar=' . $_SERVER[$svar], 'r');

	$nocontinue = 1;
	print_install_table_end();

}

// ##### Update Image Paths ###################################################
if ($_REQUEST['do'] == 'doimages')
{
	// ##### Do Path Check
	function do_path_check($imageurl, $makeclass = true)
	{
		global $vbulletin;

		if ($makeclass)
		{
			$class = exec_switch_bg();
		}

		$returnurl = $imageurl;
		if (substr($imageurl, 0, 1) == '/')
		{
			$returnurl = substr($imageurl, 1);
		}

		if (is_file('./' . $imageurl))
		{
			return array(
				'checked' => true,
				'class' => $class,
				'newpath' => $vbulletin->options['bburl'] . '/' . $returnurl
			);
		}
		else if (@getimagesize($vbulletin->options['bburl'] . '/' . $returnurl))
		{
			return array(
				'checked' => true,
				'class' => $class,
				'newpath' => $vbulletin->options['bburl'] . '/' . $returnurl
			);
		}
		else if (@getimagesize('../' . $returnurl))
		{
			return array(
				'checked' => false,
				'class' => $class,
				'newpath' => $imageurl
			);
		}
		else if (@fopen($returnurl, "r"))
		{
			return array(
				'checked' => false,
				'class' => $class,
				'newpath' => $imageurl
			);
		}
		else
		{
			return array(
				'checked' => false,
				'class' => 'redalert',
				'newpath' => $imageurl
			);
		}
	}

	// ##### Preg match for CSS Images
	function fetch_image_replaced_string($estring)
	{
		preg_match_all("#url\(([^\"]+?)\)#i", $estring, $checkimages);

		$checked = false;
		$class = exec_switch_bg();
		if (empty($checkimages[1]))
		{
			$newstring = $estring;
		}
		else
		{
			foreach ($checkimages[1] AS $imgpath)
			{
				$paths = do_path_check($imgpath . $imgcheck, false);

				$urlpos = strpos($estring, $imgpath);
				$newstring .= substr($estring, 0, $urlpos) . $paths['newpath'];

				if ($paths['checked'])
				{
					$checked = true;
				}
				if ($paths['class'] == 'redalert')
				{
					$class = 'redalert';
				}

				$estring = substr($estring, ($urlpos + strlen($imgpath)));
			}
			$newstring .= $estring;
		}

		return array(
			'class' => $class,
			'checked' => $checked,
			'newstring' => $newstring,
			'newpath' => $paths['newpath']
		);
	}

	$pagenumber = $vbulletin->input->clean_gpc('r', 'pagenumber');
	$type = $vbulletin->input->clean_gpc('r', 'type');

	$perpage = ($type == 'styleimages') ? 5 : 50;

	if (!$type)
	{
		$type = 'icons';
	}

	if (!intval($pagenumber))
	{
		$pagenumber = 1;
	}

	$minlimit = intval(($pagenumber - 1) * $perpage + 1);
	$maxlimit = intval($pagenumber * $perpage);

	print_js_form_header($scriptfile, 'updateimages');
	print_table_header('Image Paths', 5);
	print_description_row('For this part of the installation process, we will attempt to update all of your images for use with vBadvanced. Please check each image here to make sure that it is displayed properly!<br /><br />
	In most cases, it should not be necessary to make any changes here. If the current image already has the correct path then the "Update" box beside it will not be checked since no changes are necessary. If the current image does not have the correct path, but this script is able to determine the correct path, then the "Update" box will be checked and the correct URL entered into the text box. If neither of the above applies, then you will see the entire box outlined in <font color="red">red</font> and it will be necessary to modify the path yourself.', 0, 5);
	print_table_break();

	$countquery = '';
	switch ($type)
	{
		case 'icons':

			if ($vbulletin->options['showdeficon'] AND $pagenumber == 1)
			{
				print_table_break();

				print_table_header('Default Post Icon', 5);

				print_cells_row(array('Update?', 'Image Title', 'New URL', 'Current Image', 'New Image'), 'thead');

				$paths = do_path_check($vbulletin->options['showdeficon']);

				echo '<tr class="' . $paths['class'] . '"><td align="center"><input tabindex="2" type="checkbox" name="updatedicon" ' . iif($paths['checked'], 'checked="checked"') . ' value="1" /></td><td>deficon</td><td align="center"><input name="deficon" tabindex="1" type="text" value="' . $paths['newpath'] . '" size="50" /></td><td align="center"><img src="' . $vbulletin->options['showdeficon'] . '" /></td><td align="center"><img src="' . $paths['newpath'] . '" /></td></tr>';
				print_table_break();
			}

			print_table_header('Update Icon Paths', 5);
			$countquery = "icon WHERE iconpath NOT LIKE '" . $vbulletin->options['bburl'] . "%'";
		break;

		case 'smilies':
			print_table_header('Update Smilie Paths', 5);
			$countquery = "smilie WHERE smiliepath NOT LIKE '" . $vbulletin->options['bburl'] . "%'";
		break;

		case 'styleimages':
			print_table_header('Update Style Paths', 5);
			$countquery = 'style';
		break;
	}

	$itemcount = $db->query_first('SELECT COUNT(*) AS count FROM ' . TABLE_PREFIX . $countquery);

	if (!$itemcount['count'])
	{
		$nextpage = 1;
		construct_hidden_code('type', ($type == 'icons' ? 'smilies' : 'styleimages'));
		print_description_row('No ' . $type . ' need updating. Please click &quot;Save&quot; to continue', '', 5);
	}
	else
	{
		$nextpage = $pagenumber + 1;

		if ($maxlimit >= $itemcount['count'])
		{
			if ($type == 'styleimages')
			{
				$nextpage = 0;
			}
			else
			{
				$maxlimit = $itemcount['count'];
				$nextpage = 1;
				construct_hidden_code('type', ($type == 'icons' ? 'smilies' : 'styleimages'));
			}
		}
		else
		{
			construct_hidden_code('type', $type);
		}
		if ($minlimit > $itemcount['count'])
		{
			$minlimit = $itemcount['count'] - $perpage;
		}

		if ($minlimit < 1)
		{
			$minlimit = 1;
		}

		switch ($type)
		{
			// ##### Icons
			case 'icons':

				print_cells_row(array('<input type="checkbox" tabindex="999" name="allbox" title="Check All" onclick="js_check_all(this.form);" checked="checked" /> Update?', 'Image Title', 'New URL', 'Current Image', 'New Image'), 'thead');

				$icons = $db->query_read("
					SELECT *
					FROM " . TABLE_PREFIX . "icon
					WHERE iconpath NOT LIKE '" . $vbulletin->options['bburl'] . "%'
					ORDER BY iconid
					LIMIT " . ($minlimit - 1) . ", $perpage
				");
				while ($icon = $db->fetch_array($icons))
				{
					construct_hidden_code('title[' . $icon['iconid'] . ']', $icon['title']);

					$paths = do_path_check($icon['iconpath']);

					echo '<tr class="' . $paths['class'] . '">
						<td align="left"><input type="checkbox" tabindex="2" name="updateicon[' . $icon['iconid'] . ']" ' . iif($paths['checked'], 'checked="checked"') . ' value="1" /></td>
						<td>' . $icon['title'] . '</td>
						<td align="center"><input tabindex="1" name="iconpath[' . $icon['iconid'] . ']" type="text" value="' . $paths['newpath'] . '" size="50" /></td>
						<td align="center"><img src="' . $icon['iconpath'] . '" /></td><td align="center"><img src="' . $paths['newpath'] . '" /></td>
					</tr>';
				}

				print_table_break();

			break;

			// ##### Smilies
			case 'smilies':

				print_cells_row(array('<input type="checkbox" tabindex="999" name="allbox" title="Check All" onclick="js_check_all(this.form);" checked="checked" /> Update?', 'Image Title', 'New URL', 'Current Image', 'New Image'), 'thead');

				$smilies = $db->query_read("
						SELECT * FROM " . TABLE_PREFIX . "smilie
						WHERE smiliepath NOT LIKE '" . $vbulletin->options['bburl'] . "%'
						ORDER BY smilieid
						LIMIT " . ($minlimit - 1) . ", $perpage
				");
				while ($smilie = $db->fetch_array($smilies))
				{
					construct_hidden_code('title[' . $smilie['smilieid'] . ']', $smilie['title']);

					$paths = do_path_check($smilie['smiliepath']);

					echo '<tr class="' . $paths['class'] . '"><td align="left"><input type="checkbox" tabindex="2" name="updatesmilie[' . $smilie['smilieid'] . ']" ' . iif($paths['checked'], 'checked="checked"') . 'value="1" /></td><td>' . $smilie['title'] . '</td><td align="center"><input tabindex="1" name="smiliepath[' . $smilie['smilieid'] . ']" type="text" value="' . $paths['newpath'] . '" size="50" /></td><td align="center"><img src="' . $smilie['smiliepath'] . '" /></td><td align="center"><img src="' . $paths['newpath'] . '" /></td></tr>';
				}

			break;

			// ##### Style Images
			case 'styleimages':

				print_cells_row(array('<span style="white-space: nowrap"><input type="checkbox" tabindex="999" name="allbox" title="Check All" onclick="js_check_all(this.form);" checked="checked" /> Update?</span>', 'Style CSS Selector', 'New URL', 'Image Verification'), 'thead');

				// Get image titles & paths
				$scache = array();
				$styleimages = $db->query_read("
					SELECT * FROM " . TABLE_PREFIX . "template
					WHERE title IN('imgdir_attach', 'imgdir_button', 'imgdir_editor', 'imgdir_misc', 'imgdir_poll', 'imgdir_rating', 'imgdir_reputation', 'imgdir_statusicon', 'titleimage') OR (templatetype = 'css' AND template LIKE '%url(%' AND title != 'EXTRA')
				");
				while ($simage = $db->fetch_array($styleimages))
				{
					$scache["$simage[styleid]"]["$simage[title]"] = $simage['template'];
				}

				// Images to check for
				$stylechecks = array(
					'imgdir_attach' => '/attach.gif',
					'imgdir_button' => '/reply_small.gif',
					'imgdir_editor' => '/quote.gif',
					'imgdir_misc' => '/stats.gif',
					'imgdir_poll' => '/bar6-l.gif',
					'imgdir_rating' => '/rating_5.gif',
					'imgdir_reputation' => '/reputation_pos.gif',
					'imgdir_statusicon' => '/forum_new.gif'
				);

				// Get styles
				$styles = $db->query_read("
					SELECT styleid, title
					FROM " . TABLE_PREFIX . "style
					WHERE styleid != '-1'
					ORDER BY styleid, title
					LIMIT " . ($minlimit - 1) . ", $perpage
				");
				while ($style = $db->fetch_array($styles))
				{
					print_table_header($style['title'], 4, 0, '', $stylevar['left']);

					if (empty($scache[$style['styleid']]))
					{
						$scache[$style['styleid']] = $scache['-1'];
					}

					// Find anything that's in the main style but not this one.
					$defstyle = array_diff(array_keys($stylechecks), array_keys($scache[$style['styleid']]));

					if (!empty($defstyle))
					{
						foreach ($defstyle AS $varname)
						{
							$scache[$style['styleid']][$varname] = $scache['-1'][$varname];
						}
					}

					foreach ($scache[$style['styleid']] AS $varname => $imgpath)
					{
						$imagesample = '';
						if ($varname == 'EXTRA2')
						{
							$classarray = unserialize($imgpath);
							$paths = fetch_image_replaced_string($classarray['all']);

							$classinput = '<textarea name="stylepath[' . $style['styleid'] . '][' . $varname . ']" rows="8" cols="45" tabindex="1">' . htmlspecialchars($paths['newstring']) . '</textarea>';
						}

						else if (substr($varname, 0, 1) == '.' OR $varname == 'body')
						{
							$classarray = unserialize($imgpath);
							$paths = fetch_image_replaced_string($classarray['background']);

							$classinput = '<input size="45" class="bginput" name="stylepath[' . $style['styleid'] . '][' . $varname . ']" value="' . htmlspecialchars($paths['newstring']) . '" tabindex="1" />';
							$imagesample = '<img src="' . $paths['newpath'] . '" />';

						}
						else
						{
							$imgcheck = $stylechecks["$varname"];

							$paths = do_path_check($imgpath . $imgcheck);

							if (substr($varname, 0, 1) == '.')
							{
								$newpath = $paths['newpath'];
							}
							else
							{
								$newpath = substr($paths['newpath'], 0, intval(strlen($paths['newpath']) - strlen($imgcheck)));
							}

							$classinput = '<input class="bginput" name="stylepath[' . $style['styleid'] . '][' . $varname . ']" type="text" value="' . $newpath . '" size="45" tabindex="1" />';
							$imagesample = '<img src="' . $paths['newpath'] . '" />';
						}

						echo '<tr class="' . $paths['class'] . '">
								<td align="left"><input type="checkbox" tabindex="2" name="updatepath[' . $style['styleid'] . '][' . $varname . ']" ' . iif($paths['checked'], 'checked="checked"') . ' value="1" /></td>
								<td>' . $varname . '</td>
								<td align="center">' . $classinput . '</td>
							<td align="center"><div style="overflow: auto; width: 300px; max-height: 120px;">' . $imagesample . '</div></td>
						</tr>';
					}

				}
			break;

			print_table_break();
			break;
		}
	}

	construct_hidden_code('nextpage', $nextpage);
	print_submit_row('Save', 'Reset', 5);
}

// ##### Do Update Image Paths ################################################
if ($_POST['do'] == 'updateimages')
{
	$vbulletin->input->clean_array_gpc('p', array('updateicon', 'iconpath', 'updatesmilie', 'smiliepath', 'updatepath', 'stylepath', 'type' => TYPE_STR, 'nextpage' => TYPE_INT));

	$updateicon = $vbulletin->input->clean_gpc('p', 'updateicon');
	$iconpath = $vbulletin->input->clean_gpc('p', 'iconpath');
	$updatesmilie = $vbulletin->input->clean_gpc('p', 'updatesmilie');
	$smiliepath = $vbulletin->input->clean_gpc('p', 'smiliepath');
	$updatepath = $vbulletin->input->clean_gpc('p', 'updatepath');
	$stylepath = $vbulletin->input->clean_gpc('p', 'stylepath');
	$type = $vbulletin->input->clean_gpc('p', 'type');
	$nextpage = $vbulletin->input->clean_gpc('p', 'nextpage', TYPE_INT);
	$deficon = $vbulletin->input->clean_gpc('p', 'deficon', TYPE_NOHTML);

	// ##### Update Style Images
	if (is_array($updatepath))
	{
		// Get image titles & paths
		$defstyle = array();
		$styleimages = $db->query_read("
			SELECT title, template FROM " . TABLE_PREFIX . "template
			WHERE title IN('imgdir_attach', 'imgdir_button', 'imgdir_editor', 'imgdir_misc', 'imgdir_poll', 'imgdir_rating', 'imgdir_reputation', 'imgdir_statusicon', 'titleimage') OR (templatetype = 'css' AND template LIKE '%url(%') AND styleid = '-1'
		");
		while ($simage = $db->fetch_array($styleimages))
		{
			$defstyle["$simage[title]"] = $simage['template'];
		}

		foreach ($updatepath AS $sid => $values)
		{
			$sid = intval($sid);

			$tempcache = array();
			$gettemps = $db->query_read("
				SELECT title, template
				FROM " . TABLE_PREFIX . "template
				WHERE title IN('" . implode("', '", array_keys($values)) . "')
					AND styleid = $sid
			");
			while ($temps = $db->fetch_array($gettemps))
			{
				$tempcache[$temps['title']] = $temps['template'];
			}

			foreach ($values AS $var => $update)
			{
				if ($update)
				{
					$insert = false;
					$newtemp = $stylepath[$sid][$var];

					if (!isset($tempcache[$var]))
					{
						$insert = true;
						$tempcache[$var] = $defstyle[$var];
					}

					// EXTRA
					if ($var == 'EXTRA2')
					{
						$template = unserialize($tempcache[$var]);
						$template['all'] = $newtemp;
						$newtemp = serialize($template);
					}
					// CSS Class
					else if (substr($var, 0, 1) == '.' OR $var == 'body')
					{
						$template = unserialize($tempcache[$var]);

						$template['background'] = $newtemp;

						$newtemp = serialize($template);
					}

					if ($insert)
					{
						$db->query_write("
							INSERT INTO " . TABLE_PREFIX . "template
								(styleid, title, template, template_un, templatetype, dateline, username, product)
							VALUES (
								'$sid',
								'$var',
								'" . $db->escape_string($newtemp) . "',
								'',
								'" . iif(substr($var, 0, 1) == '.', 'css', 'stylevar') . "',
								" . TIMENOW . ",
								'" . $db->escape_string($vbulletin->userinfo['username']) . "',
								'vbulletin'
						)");
					}
					else
					{
						$db->query_write("UPDATE " . TABLE_PREFIX . "template SET template = '" . $db->escape_string($newtemp) . "' WHERE title = '$var' AND styleid = '$sid'");
					}
				}
			}
		}
		build_all_styles(0, 0, $scriptfile . '.php?do=finished');
	}

	// ##### Update Icons
	else if (is_array($updateicon))
	{
		foreach ($iconpath AS $key => $val)
		{
			if ($updateicon[$key])
			{
				$db->query_write("
					UPDATE " . TABLE_PREFIX . "icon SET
						iconpath = '" . $db->escape_string($val) . "'
					WHERE iconid = '" . $db->escape_string($key) . "'
				");
			}
		}
		build_image_cache('icon');
	}

	// ##### Update Smilies
	else if (is_array($updatesmilie))
	{
		foreach ($smiliepath AS $key => $val)
		{
			if ($updatesmilie[$key])
			{
				$db->query_write("
					UPDATE " . TABLE_PREFIX . "smilie SET
						smiliepath = '" . $db->escape_string($val) . "'
					WHERE smilieid = '" . $db->escape_string($key) . "'
				");
			}
		}
		build_image_cache('smilie');
	}

	// ##### Default Icon URL
	if ($_POST['updatedicon'])
	{
		$db->query_write("UPDATE " . TABLE_PREFIX . "setting SET value = '$deficon' WHERE varname = 'showdeficon'");
		echo '<br />showdeficon updated.<br />';
		build_options();
	}

	if ($nextpage)
	{
		print_cp_redirect($scriptfile . '.php?do=doimages&type=' . $type . '&pagenumber=' . $nextpage);
	}
	else
	{
		print_cp_redirect($scriptfile . '.php?do=finished');
	}
}

// ##### Upgrade ##############################################################
if ($_REQUEST['do'] == 'upgrade')
{
	$step = intval($_REQUEST['step']);

	print_install_table_start('vBadvanced ' . $scriptname . ' Upgrade', 'upgrade');

	$vcheck = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "adv_setting WHERE varname = 'portal_version'");

	if ($vcheck['value'] == $version)
	{
		$stepphrase = 'You are already running the current version of vBadvanced ' . $scriptname . '!';
		$nocontinue = 1;
	}
	else if (!$vcheck['value'])
	{
		$stepphrase = 'vBadvanced ' . $scriptname . ' is not installed! Please choose the option to install from the main page.';
		$nocontinue = 1;
	}
	else
	{
		// set here for any new tables added during an upgrade
		$enginevar = 'ENGINE';
		if (version_compare(MYSQL_VERSION, '4.0.18', '<'))
		{
			$enginevar = 'TYPE';
		}

		switch ($vcheck['value'])
		{
			case 'RC2':
			case '1.0.0':

				$db->query_write("UPDATE " . TABLE_PREFIX . "adv_settinggroup SET displayorder = displayorder+1 WHERE grouptitle LIKE 'adv_portal%'");

				$checkglobal = $db->query_first("SELECT grouptitle FROM " . TABLE_PREFIX . "adv_settinggroup WHERE grouptitle = 'adv_global'");

				if (!$checkglobal['grouptitle'])
				{
					$db->query_write("INSERT INTO " . TABLE_PREFIX . "adv_settinggroup VALUES ('adv_global', 1)");
					insert_phrase('settinggroup_adv_global', 'Global vBadvanced Settings', 5000);
				}

			case '1.0.1':

				// Alter module table
				$db->query_write("
					ALTER TABLE " . TABLE_PREFIX . "adv_modules
					ADD parent varchar(255) NOT NULL default '',
					ADD colspan smallint(3) unsigned NOT NULL default '0',
					ADD formcode text NOT NULL,
					ADD cleanoutput smallint(3) unsigned NOT NULL default '0',
					ADD useshell smallint(3) unsigned NOT NULL default '0',
					ADD link varchar(255) NOT NULL default '',
					ADD options text NOT NULL,
					CHANGE filename filename text NOT NULL,
					CHANGE inctype inctype varchar(20) NOT NULL default ''
				");
				$stepphrase .= 'Altered adv_modules table to include new fields.<br />';

				// Alter page table
				$db->query_write("
					ALTER TABLE " . TABLE_PREFIX . "adv_pages ADD type varchar(50) NOT NULL default '' AFTER name,
					ADD parentid int(10) unsigned NOT NULL default '0' AFTER template,
					ADD parentlist varchar(255) NOT NULL default '' AFTER template,
					ADD active smallint(3) unsigned NOT NULL default '0',
					ADD colspan smallint(3) unsigned NOT NULL default '0',
					ADD formcode text NOT NULL,
					ADD cleanoutput smallint(3) unsigned NOT NULL default '0',
					ADD useshell smallint(3) unsigned NOT NULL default '0',
					ADD custom_title varchar(255) NOT NULL default '',
					CHANGE template template text NOT NULL
				");
				$stepphrase .= 'Altered adv_pages table to include new fields.<br /><br />';

				$db->query_write("UPDATE " . TABLE_PREFIX . "adv_pages SET active = 1");
				$db->query_write("UPDATE " . TABLE_PREFIX . "adv_pages SET type = 'template' WHERE template != ''");
				$db->query_write("UPDATE " . TABLE_PREFIX . "adv_pages SET type = 'module' WHERE type = ''");

				$getpsetting = $db->query_read("SELECT pageid, advanced FROM " . TABLE_PREFIX . "adv_pages WHERE advanced != ''");
				while ($psetting = $db->fetch_array($getpsetting))
				{
					$psetting['advanced'] = unserialize($psetting['advanced']);
					$pagesettings = array();
					if (!empty($psetting['advanced']))
					{
						foreach ($psetting['advanced'] AS $varname => $value)
						{
							$sgroup = $db->query_first("SELECT grouptitle FROM " . TABLE_PREFIX . "adv_setting WHERE varname = '$varname'");
							$pagesettings["$sgroup[grouptitle]"]["$varname"] = $value;
						}
					}
					$db->query_write("UPDATE " . TABLE_PREFIX . "adv_pages SET advanced = '" . serialize($pagesettings) . "' WHERE pageid = '$psetting[pageid]'");
				}

				$stepphrase = 'Updated page settings.<br /><br />';

				$db->query_write("UPDATE " . TABLE_PREFIX . "adv_modules SET inctype = 'php_file' WHERE inctype = 0");
				$db->query_write("UPDATE " . TABLE_PREFIX . "adv_modules SET inctype = 'template' WHERE inctype = 1");
				$db->query_write("UPDATE " . TABLE_PREFIX . "adv_modules SET inctype = 'custom' WHERE inctype = 2");

				$db->query_write("INSERT INTO " . TABLE_PREFIX . "datastore (title) VALUES ('adv_portal_page')");

				// Update module usergroup perms
				$getoldmods = $db->query_read("SELECT modid, userperms FROM " . TABLE_PREFIX . "adv_modules");
				while ($oldmod = $db->fetch_array($getoldmods))
				{
					if (!$oldmod['userperms'])
					{
						$db->query_write("UPDATE " . TABLE_PREFIX . "adv_modules SET userperms = '" . implode(',', array_keys($vbulletin->usergroupcache)) . "' WHERE modid = '$oldmod[modid]'");
					}
				}

				// Update Modules
				foreach ($vba_modules AS $modid => $module)
				{
					if (in_array($module['identifier'], array('navigation', 'birthdays')))
					{
						if ($module['identifier'] == 'navigation')
						{
							$module['active'] = 0;
						}
						$module['userperms'] = implode(',', array_keys($vbulletin->usergroupcache));
						$db->query_read(fetch_query_sql($module, 'adv_modules'));
					}
					else
					{

						$db->query_write("UPDATE " . TABLE_PREFIX . "adv_modules SET identifier = '$module[identifier]', inctype = '$module[inctype]', templatelist = '$module[templatelist]', parent = '$module[parent]', colspan = '$module[colspan]', formcode = '$module[formcode]', useshell = '$module[useshell]', link = '$module[link]' WHERE filename = '$module[filename]' " . iif(in_array($module['filename'], array('news.php', 'onlineusers.php')), "AND identifier = '$module[identifier]'"));
					}
				}

				$stepphrase .= 'Updated modules.<br /><br />';

				// Update settings

				$db->query_write("UPDATE " . TABLE_PREFIX . "adv_setting SET grouptitle = 'adv_portal_calendar' WHERE varname = 'portal_calendarid'");
				$db->query_write("UPDATE " . TABLE_PREFIX . "adv_setting SET grouptitle = 'adv_portal_style' WHERE varname IN('portal_shownavbar', 'portal_colspacing', 'portal_rightcolwidth', 'portal_leftcolwidth', 'portal_blockbullet')");

				$db->query_write("INSERT INTO " . TABLE_PREFIX . "adv_settinggroup VALUES ('adv_portal_style', 3)");

				$db->query_write("DELETE FROM " . TABLE_PREFIX . "template WHERE title IN('adv_portal', 'adv_portal_buddylist', 'adv_portal_buddylistbits', 'adv_portal_calendar', 'adv_portal_latesttopicbits', 'adv_portal_latesttopics', 'adv_portal_moderation', 'adv_portal_newsbits', 'adv_portal_news_archive', 'adv_portal_news_archivebits', 'adv_portal_onlineusers', 'adv_portal_poll', 'adv_portal_polloption', 'adv_portal_polloption_multiple', 'adv_portal_pollresult', 'adv_portal_search', 'adv_portal_stats', 'adv_portal_welcomeblock')");

				$chpoll = $db->query_first("SELECT value FROM " . TABLE_PREFIX . "adv_setting WHERE varname = 'portal_poll_forumid'");

				// Check poll value
				if ($chpoll['value'] == 'RAND')
				{
					$db->query_write("UPDATE " . TABLE_PREFIX . "adv_setting SET value = '" . implode(',', array_keys($vbulletin->forumcache)) . "' WHERE varname = 'portal_poll_forumid'");
					$db->query_write("UPDATE " . TABLE_PREFIX . "adv_setting SET value = 'rand' WHERE varname = 'portal_poll_orderby'");
				}

			case '2.0 RC1 (vB 3.5)':
			case '2.0 RC1':

				// Alter adv_pages table to include meta and displayorder
				$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_pages ADD meta TEXT NOT NULL, ADD displayorder SMALLINT(4) UNSIGNED DEFAULT '0' NOT NULL");

				kill_phrase('edit_template_in_style', 'adv_portal_cp');

				$stepphrase .= 'Updated phrases.<br /><br />';

			case '2.0 RC2 (vB 3.5)':
			case '2.0 RC2':

				$db->query_write("UPDATE " . TABLE_PREFIX . "adv_modules SET colspan = 6 WHERE identifier = 'newsarchive'");
				$stepphrase .= 'Updated News Archive colspan.<br /><br />';

				kill_phrase('adv_portal_must_choose_file_include', 1000);

			case '2.0.0':

				// Update module links & form code
				$getmods = $db->query_read("SELECT modid, formcode, link FROM " . TABLE_PREFIX . "adv_modules");
				while ($mod = $db->fetch_array($getmods))
				{
					$mod['link'] = str_replace('$vboptions[bburl]', '{$vbulletin->options[bburl]}', $mod['link']);
					$mod['formcode'] = str_replace('$vboptions[bburl]', '{$vbulletin->options[bburl]}', $mod['formcode']);

					$db->query_write("UPDATE " . TABLE_PREFIX . "adv_modules SET formcode = '$mod[formcode]', link = '$mod[link]' WHERE modid = '$mod[modid]'");
				}

				foreach ($vba_modules AS $modid => $module)
				{
					if ($module['link'])
					{
						$db->query_write("UPDATE " . TABLE_PREFIX . "adv_modules SET link = '" . $db->escape_string($module['link']) . "' WHERE identifier = '$module[identifier]'");
					}
				}

				update_module_cache();

			case '2.0.0 (vB 3.5)':

				$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_modules, ADD COLUMN code_parsed text NOT NULL");
				$stepphrase .= 'Altered adv_modules table to add code_parsed column.<br /><br />';

				$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_modules CHANGE templatelist templatelist TEXT NOT NULL");
				$stepphrase .= 'Altered adv_modules table to allow more characters in the templatelist field.';

				$freplace = $db->query_first("SELECT value FROM " . TABLE_PREFIX . "adv_setting WHERE varname = 'global_footer_replace'");

				$freplace['value'] = explode("\r\n", $freplace['value']);

				if (!in_array('profile.php', $freplace['value']))
				{
					$freplace['value'][] = 'profile.php';

					$db->query_write("UPDATE " . TABLE_PREFIX . "adv_setting SET value = '" . $db->escape_string(implode("\r\n", $freplace['value'])) . "' WHERE varname = 'global_footer_replace'");
					$stepphrase = 'Added profile.php to footer replacements.<br /><br />';
				}

				$db->query_write("ALTER TABLE " . TABLE_PREFIX . "session ADD newposts INT(10) UNSIGNED NULL");
				$stepphrase = 'Altered session table to add newposts field.<br /><br />';

				include_once('./includes/class_bbcode.php');
				include_once('./includes/functions_forumdisplay.php');

				$bbcode_parser =& new vB_BbCodeParser($vbulletin, fetch_tag_list());

				$getmods = $db->query_read("SELECT modid, filename, options FROM " . TABLE_PREFIX . "adv_modules WHERE inctype = 'bb_code'");
				while ($mod = $db->fetch_array($getmods))
				{
					$setting = unserialize($mod['options']);

					$db->query_write("UPDATE " . TABLE_PREFIX . "adv_modules SET code_parsed = '" . $db->escape_string($bbcode_parser->do_parse($mod['filename'], $setting['allow_html'], $setting['allow_smilies'], 1, $setting['allow_image_code'])) . "' WHERE modid = '$mod[modid]'");
				}
				$stepphrase = 'Updated BB code modules.<br /><br />';

				$db->query_write("INSERT INTO " . TABLE_PREFIX . "product (productid, title, description, version, active) VALUES ('" . PRODUCT_CODE . "', 'vBadvanced CMPS', 'vBadvanced Content Management & Portal System', '" . $version . "', 1)");

				$stepphrase .= 'Added CMPS to products.<br /><br />';

				$db->query_write("UPDATE " . TABLE_PREFIX . "plugin SET devkey = 'adv_error' WHERE devkey = 'vba_error'");

				foreach ($mainphrases AS $phrasetypeid => $phrases)
				{
					$db->query_write("UPDATE " . TABLE_PREFIX . "phrase SET product = '" . PRODUCT_CODE . "' WHERE fieldname = '$phrasetypeid' AND varname IN('" . implode("', '", array_keys($phrases)) . "')");
				}

				$stepphrase .= 'Added / updated phrases.<br /><br />';


				$db->query_write("INSERT INTO " . TABLE_PREFIX . "datastore (title) VALUES ('adv_portal_tpst')");
				$stepphrase .= 'Inserted top poster field to datastore table.<br /><br />';

			case '2.1.0':
			case '2.2.0':

				$db->query_write("UPDATE " . TABLE_PREFIX . "datastore SET unserialize = 1 WHERE title IN('adv_portal_opts', 'adv_modules', 'adv_portal_page', 'adv_portal_tpst')");

				$stepphrase .= 'Updated datastore entries.<br />';

				$db->query_write("UPDATE " . TABLE_PREFIX . "product SET description = 'vBadvanced Content Management & Portal System' WHERE productid = '" . PRODUCT_CODE . "'");

				update_page_cache();

			case '2.2.1':
			case '2.2.1 (vB 3.6)':

				// First version of the CMPS with the serialize column
				$db->reporterror = 0;
				$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_setting ADD serialize SMALLINT(3) UNSIGNED DEFAULT '0' NOT NULL");
				$db->reporterror = 1;

				// Cache the modules and update it all below
				$modcache = array();
				$getmods = $db->query_read("
					SELECT modid, modcol, identifier, parent, displayorder, filename, templatelist
					FROM " . TABLE_PREFIX . "adv_modules
					ORDER BY modcol, displayorder
				");
				while ($mod = $db->fetch_array($getmods))
				{
					$modcache[$mod['modid']] = $mod;
				}

				// Page layouts & settings
				$getpages = $db->query_read("SELECT pageid, modules, advanced FROM " . TABLE_PREFIX . "adv_pages");
				while ($page = $db->fetch_array($getpages))
				{
					$layout = array(
						1 => array(),
						2 => array(),
						3 => array()
					);

					$page['modules'] = explode(',', $page['modules']);

					if (!empty($page['modules']))
					{
						foreach ($modcache AS $modcid => $modc)
						{
							if (in_array($modcid, $page['modules']))
							{
								$layout[($modc['modcol'] + 1)][$modcid] = $modc['displayorder'];
							}
						}

						foreach ($layout AS $column => $mods)
						{
							asort($layout[$column], SORT_NUMERIC);
						}
					}

					$page['advanced'] = unserialize($page['advanced']);

					// Format the advanced settings
					if (!empty($page['advanced']))
					{
						foreach ($page['advanced'] AS $adv_group => $adv_settings)
						{
							if (!empty($adv_settings))
							{
								foreach ($adv_settings AS $adv_varname => $adv_value)
								{
									switch ($adv_varname)
									{
										case 'portal_navigation_excludepages':
											$page['advanced'][$adv_group][$adv_varname] = explode(',', $adv_value);
										break;

										case 'portal_navigation_addpages':
										case 'portal_threadids':
											if (!is_array($adv_value))
											{
												$page['advanced'][$adv_group][$adv_varname] = unserialize($adv_value);
											}
										break;

										case 'portal_threads_forumids':
										case 'portal_news_forumid':
										case 'portal_poll_forumid':
										case 'portal_navigation_excludepages':
											$page['advanced'][$adv_group][$adv_varname] = ($adv_value) ? explode(',', $adv_value) : array();
										break;
									}
								}
							}
						}
					}

					$db->query_write("
						UPDATE " . TABLE_PREFIX . "adv_pages SET
							modules = '" . $db->escape_string(serialize($layout)) . "',
							advanced = '" . $db->escape_string(serialize($page['advanced'])) . "'
						WHERE pageid = $page[pageid]
					");
				}

				// Pages table alterations
				$db->query_write("
					ALTER TABLE " . TABLE_PREFIX . "adv_pages
						CHANGE modules modules TEXT NOT NULL,
						CHANGE advanced advanced TEXT NOT NULL
				");

				$stepphrase .= 'Finished adv_pages table alterations.<br /><br />';

				require_once(DIR . '/includes/functions_misc.php');

				$modoptfiles = array();
				foreach ($vba_modules AS $modid => $module)
				{
					if ($module['options'])
					{
						// Distinguish between the parent and child
						if ($module['parent'])
						{
							$module['filename'] .= '-child';
						}
						$modoptfiles[$module['filename']] = $module['options'];
					}
				}

				// Update templatelist's to use new format
				foreach ($modcache AS $modid => $modinfo)
				{
					$modupdatequery = array();
					if (trim($modinfo['templatelist']))
					{
						$tlist = array_map('trim', explode(',', $modinfo['templatelist']));

						if ($modinfo['parent'])
						{
							$modinfo['filename'] .= '-child';
						}

						// Add new templates
						switch ($modinfo['filename'])
						{
							case 'latesttopics.php':
								$tlist = array_diff($tlist, array(
										'adv_portal_latesttopicbits',
										'adv_portal_latestthreads_head',
										'adv_portal_latesttopics'
								));
								$tlist[] = 'adv_portal_recthreads_lean';
								$tlist[] = 'adv_portal_recthreads_exp';
								$tlist[] = 'adv_portal_recthreads_exp_head';
							break;

							case 'news.php':
								if ($modinfo['parent'])
								{
									$tlist = array_diff($tlist, array(
											'adv_portal_news_archive_head',
											'adv_portal_news_archivebits'
									));
									$tlist[] = 'adv_portal_archivebits_exp';
									$tlist[] = 'adv_portal_archivebits_exp_head';
									$tlist[] = 'adv_portal_archivebits_lean';
								}
							break;

							case 'welcomeblock.php':
								unset($tlist['adv_portal_welcomeblock']);

								$tlist[] = 'adv_portal_welcomeblock_lean';
								$tlist[] = 'adv_portal_welcomeblock_expanded';
							break;
						}

						$tlist = implode("\r\n", $tlist);

						$modupdatequery[] = "templatelist = '" . $db->escape_string($tlist) . "'";
					}

					// Change from serialized array to bitfield
					if ($modinfo['inctype'] == 'bbcode')
					{
						$modinfo['options'] = unserialize($modinfo['options']);
						$newopts = convert_array_to_bits($modinfo['options'], $vba_bbc_modint);

						$modupdatequery[] = "options = '$newopts'";
					}

					if ($modinfo['identifier'] AND $modinfo['filename'])
					{
						$modupdatequery[] = "options = '" . intval($modoptfiles[$modinfo['filename']]) . "'";
					}

					if (!empty($modupdatequery))
					{
						$db->query_write("
							UPDATE " . TABLE_PREFIX . "adv_modules SET
								" . implode(', ', $modupdatequery) . "
							WHERE modid = $modid
						");
					}
				}


				// Delete old templates from master style
				$db->query_write("
					DELETE FROM " . TABLE_PREFIX . "template
					WHERE title IN(
						'adv_portal_latesttopicbits',
						'adv_portal_latestthreads_head',
						'adv_portal_latesttopics',
						'adv_portal_news_archive_head',
						'adv_portal_news_archivebits',
						'adv_portal_welcomeblock'
					) AND styleid = '-1'
				");

				// Update the latest topics module to use recentthreads.php
				$db->query_write("UPDATE " . TABLE_PREFIX . "adv_modules SET filename = 'recentthreads.php' WHERE filename = 'latesttopics.php'");

				$db->query_write("UPDATE " . TABLE_PREFIX . "adv_modules SET options = 8 WHERE cleanoutput = 1");

				$db->query_write("
					ALTER TABLE " . TABLE_PREFIX . "adv_modules
						DROP modcol,
						DROP displayorder,
						DROP cleanoutput,
						CHANGE options options SMALLINT(3) NOT NULL
				");

				$stepphrase .= 'Finished adv_modules table alterations.<br /><br />';


				// Add homepage cache
				$db->query_write("INSERT INTO " . TABLE_PREFIX . "datastore (title, unserialize) VALUES ('adv_portal_home', 1)");

				$stepphrase .= 'Added homepage cache datastore entry.<br /><br />';

				// Update forumid settings to serialize instead of explode
				$getforumsettings = $db->query_read("
					SELECT varname, grouptitle, value
					FROM " . TABLE_PREFIX . "adv_setting
					WHERE varname IN('portal_threads_forumids', 'portal_news_forumid', 'portal_poll_forumid', 'portal_navigation_excludepages')
				");
				while ($forumsetting = $db->fetch_array($getforumsettings))
				{
					$forumsetting['value'] = ($forumsetting['value']) ? explode(',', $forumsetting['value']) : array();
					$db->query_write("
						UPDATE " . TABLE_PREFIX . "adv_setting SET
							value = '" . $db->escape_string(serialize($forumsetting['value'])) . "'
						WHERE varname = '$forumsetting[varname]'
							AND grouptitle = '$forumsetting[grouptitle]'
					");
				}

				$db->query_write("UPDATE " . TABLE_PREFIX . "adv_setting SET serialize = 1 WHERE varname IN('portal_threads_forumids', 'portal_threadids')");

				// Update module shell template name
				$db->query_write("
					UPDATE " . TABLE_PREFIX . "template SET
						title = 'adv_portal_module_wrapper'
					WHERE title = 'adv_portal_module_shell'
				");

				$db->query_write("
					DELETE FROM " . TABLE_PREFIX . "phrase
					WHERE fieldname = 'adv_portal'
						AND varname IN('news_archive', 'on', 'quick_moderation', 'x_attachment', 'x_events', 'x_posts', 'x_threads', 'x_users')
				");

				$db->query_write("
					DELETE FROM " . TABLE_PREFIX . "phrase
					WHERE fieldname = 'adv_portal_cp'
						AND varname IN('hide_module_settings', 'module_identifier', 'module_name', 'module_shell_template_options', 'options_apply_to_module_shell', 'or_template_to_include', 'page_template', 'page_template_description', 'show_module_settings', 'template_note_prefixes', 'templates_used_note', 'this_what_used_identify_module',	'update_all_pages', 'use_module_shell_template')
				");


				$db->query_write("
					DELETE FROM " . TABLE_PREFIX . "phrase
					WHERE fieldname = 'error' AND varname IN('adv_portal_must_choose_include')
				");

				$stepphrase .= 'Removed old phrases.<br /><br />';

			case '3.0 Beta 1':
				$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_modules ADD altshell VARCHAR(255) NOT NULL AFTER useshell");

				// This part only needs to be run if they were actually running the beta
				if ($vcheck['value'] == '3.0 Beta 1')
				{
					$db->query_write("UPDATE " . TABLE_PREFIX . "adv_modules SET options = options+16 WHERE filename IN('recentthreads.php', 'currentpoll.php', 'news.php')");

					$colsetting = $db->query_first("SELECT value FROM " . TABLE_PREFIX . "adv_setting WHERE varname = 'portal_column_array'");
					$colvals = explode("\r\n", $colsetting['value']);

					$newcolumns = array();
					if (!empty($colvals))
					{
						foreach ($colvals AS $coldata)
						{
							$coldata = explode('|', $coldata);

							if (intval($coldata[0]) AND trim($coldata[1]))
							{
								$newcolumns[$coldata[0]] = $coldata[1];
							}
						}
					}

					$db->query_write("UPDATE " . TABLE_PREFIX . "adv_setting SET value = '" . $db->escape_string(serialize($newcolumns)) . "' WHERE varname = 'portal_column_array'");
				}

				// Turn the module function setting off for upgrades so custom modules won't break
				$mainsettings['adv_portal_main']['portal_use_module_function']['value'] = 0;

			case '3.0 RC1':

				// Make sure the custom page content module was not deactivated in a previous version
				$db->query_write("UPDATE " . TABLE_PREFIX . "adv_modules SET active = 1 WHERE inctype = 'custom'");

			case '3.0 RC2':

				$stepphrase .= 'Adding index on poll table.<br /><br />';
				vbflush();
				add_table_index('poll', 'dateline');

				kill_template('recthreads_expanded');
				kill_phrase('discuss_this_poll');

				// Could still be around from old CMPS versions
				$db->query_write("DELETE FROM " . TABLE_PREFIX . "adv_settinggroup WHERE grouptitle = 'adv_portal_misc'");
				$db->query_write("DELETE FROM " . TABLE_PREFIX . "adv_setting WHERE grouptitle = 'adv_portal_misc'");

				$db->reporterror = 0; // not sure how people are getting dupe errors, but they are
				$db->query_write("INSERT INTO " . TABLE_PREFIX . "datastore (title, data, unserialize) VALUES ('adv_portal_pars', '', 1)");
				$db->reporterror = 1;

				$db->query_write("UPDATE " . TABLE_PREFIX . "datastore SET title = 'adv_portal_stat', data = '' WHERE title = 'adv_portal_tpst'");
				$stepphrase .= 'Renamed the stats module datastore title.<br /><br />';

				$getmods = array();
				foreach ($vba_modules AS $modid => $module)
				{
					if ($module['identifier'])
					{
						$getmods[] = "'$module[identifier]'";
					}
				}

				// Update Module Links
				$querymods = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "adv_modules WHERE identifier IN(" . implode(', ', $getmods) . ")");
				while ($mods = $db->fetch_array($querymods))
				{
					$linkcheck = strstr($mods['link'], '$session[sessionurl]');
					$newlink = '';

					if ($linkcheck)
					{
						if ($linkcheck == '$session[sessionurl]')
						{
							$newlink = '{$vbulletin->session->vars[sessionurl_q]}';
							$findtext = '?$session[sessionurl]';
						}
						else
						{
							$newlink = '{$vbulletin->session->vars[sessionurl]}';
							$findtext = '$session[sessionurl]';
						}

						$db->query_write("
							UPDATE " . TABLE_PREFIX . "adv_modules SET
								link = '" . str_replace($findtext, $newlink, $mods['link']) . "'
								WHERE modid = $mods[modid]
						");
					}
				}

				$stepphrase .= 'Updated module links to replace $session[sessionurl] with {$vbulletin->session->vars[sessionurl].<br /><br />';

				// Insert tags module
				$tagsmod = $vba_modules['15'];

				$tagsmod['userperms'] = implode(',', array_keys($vbulletin->usergroupcache));
				$tagsmod['templatelist'] = str_replace(' ', "\r\n", $tagsmod['templatelist']);

				$db->query_write(fetch_query_sql($tagsmod, 'adv_modules'));

				$stepphrase .= 'Inserted &quot;Popular Tags&quot; module.<br /><br />';

			case '3.0.0':

				// Update modules to add security token
				$querymods = $db->query_read("SELECT modid, formcode FROM " . TABLE_PREFIX . "adv_modules WHERE formcode LIKE '%<form%'");
				while ($mods = $db->fetch_array($querymods))
				{
					if (strpos($mods['formcode'], 'securitytoken') === false)
					{
						$mods['formcode'] .= '<input type="hidden" name="securitytoken" value="{$vbulletin->userinfo[securitytoken]}" />';
						$db->query_write("
							UPDATE " . TABLE_PREFIX . "adv_modules SET
								formcode = '" . $db->escape_string($mods['formcode']) . "'
							WHERE modid = $mods[modid]
						");
					}
				}

			case '3.0.1':

				// Alter page table
				$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_pages CHANGE useshell useshell smallint(3) unsigned NOT NULL default '0'");

			case '3.1.0':

				$db->query_write("
					CREATE TABLE " . TABLE_PREFIX . "adv_pages_user (
					  pageid int(10) unsigned NOT NULL default '0',
					  userid int(10) unsigned NOT NULL default '0',
					  layout text NOT NULL,
					  UNIQUE KEY pageid (pageid,userid)
					) $enginevar=MyISAM
				");
				
				$stepphrase .= 'Created adv_pages_user table.<br /><br />';

				$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_modules ADD dyna_prefix VARCHAR(50) NOT NULL");
				$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_pages ADD customize SMALLINT(3) UNSIGNED NOT NULL DEFAULT '0' AFTER useshell");

				$stepphrase .= 'Updated new columns.<br /><br />';

				$db->query_write("UPDATE " . TABLE_PREFIX . "adv_setting SET grouptitle = '' WHERE varname = 'portal_replaceadmin' AND grouptitle = 'adv_portal_main'");

			case '3.2.0':

				$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_pages ADD dateline INT(10) UNSIGNED NOT NULL DEFAULT '0'");
				$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_pages_user ADD dateline INT(10) UNSIGNED NOT NULL DEFAULT '0'");

			// #####
			default:

				// ##### Templates
				insert_all_templates();

				$rebuildtemp = true;

				$stepphrase .= 'Updated templates.<br /><br />';
				vbflush();

				$db->query_write("
					UPDATE " . TABLE_PREFIX . "adv_setting SET
						value = '$version'
					WHERE varname = 'portal_version'
				");

				$db->query_write("
					UPDATE " . TABLE_PREFIX . "product SET
						version = '" . $version . "',
						url = 'http://www.vbadvanced.com'
					WHERE productid = '" . PRODUCT_CODE . "'
				");

				$stepphrase .= 'Updated version number.<br /><br />';

				// Update the settings, and phrases are handled within the function too
				rebuild_all_settings();

				$stepphrase .= 'Added / updated phrases.<br /><br />';
				$stepphrase .= 'Updated current settings and added any new ones.<br /><br />';

				insert_plugins();

				update_page_cache();
				update_homepage_cache();

				update_module_cache();

				if (in_array($vcheck['value'], array('1.0.0', '1.0.1', 'RC2')))
				{
					construct_hidden_code('redirect', 'finished');
					$nextdo = 'alttables';
				}
				else
				{
					$nextdo = 'finished';
				}

		}
	}

	print_install_table_end();
}

// ##### Uninstall ############################################################
if ($_REQUEST['do'] == 'uninstall')
{
	$step = $_REQUEST['step'];
	$forumsoff = intval($_REQUEST['forumsoff']);

	print_install_table_start('vBadvanced ' . $scriptname . ' Uninstall', 'uninstall');

	$db->reporterror = 0;

	switch ($step)
	{
		case 1:
			$stepphrase = 'We\'re sorry you didn\'t like vBadvanced ' . $scriptname . '. Running this script will remove all changes that were made for vBadvanced ' . $scriptname . '.</div>';
		break;

		case 2:

			if ($vbulletin->options['bbactive'])
			{
				print_description_row('Please turn your forums off before proceeding', '', 2, 'thead');
				print_textarea_row('Forums closed message:', 'closedmessage', $vbulletin->options['bbclosedreason'], 4, 40, 1, 0);
				construct_hidden_code('redirect', 'uninstall');
				$nextdo = 'closeforums';
			}
			else
			{
				print_cp_redirect($scriptfile . '.php?do=uninstall&amp;step=3');
			}

		break;

		case 3:

			$db->query_write("DROP TABLE " . TABLE_PREFIX . "adv_modules");
			$db->query_write("DROP TABLE " . TABLE_PREFIX . "adv_pages");
			$db->query_write("DROP TABLE " . TABLE_PREFIX . "adv_pages_user");

			$stepphrase .= 'Removed tables.<br /><br />';

			$db->query_write("DELETE FROM " . TABLE_PREFIX . "phrase WHERE fieldname IN('adv_portal','adv_portal_cp')");

			$db->query_write("DELETE FROM " . TABLE_PREFIX . "phrasetype WHERE fieldname IN('adv_portal','adv_portal_cp')");

			$db->query_write("
				ALTER TABLE " . TABLE_PREFIX . "language
					DROP phrasegroup_adv_portal,
					DROP phrasegroup_adv_portal_cp
			");

			$stepphrase .= 'Removed phrases.<br /><br />';

			$db->query_write("DELETE FROM " . TABLE_PREFIX . "product WHERE productid = '" . PRODUCT_CODE . "'");

			$db->query_write("DELETE FROM " . TABLE_PREFIX . "plugin WHERE devkey IN('" . implode("', '", array_keys($vba_plugins)) . "') AND product = 'adv_cmps'");

			$stepphrase .= 'Remove product and plugins.<br /><br />';

			$db->query_write("ALTER TABLE " . TABLE_PREFIX . "session DROP newposts");
			$stepphrase .= 'Altered session table to remove newposts field.<br /><br />';

			$db->query_write("DELETE FROM " . TABLE_PREFIX . "template WHERE product = 'adv_cmps'");

			$stepphrase .= 'Removed templates.<br /><br />';

			unset($mainsettings['adv_global']);
			unset($adv_settinggroups['adv_global']);

			$db->query_write("DELETE FROM " . TABLE_PREFIX . "adv_setting WHERE grouptitle LIKE 'adv_portal%'");
			$db->query_write("DELETE FROM " . TABLE_PREFIX . "adv_settinggroup WHERE grouptitle LIKE 'adv_portal%'");

			$stepphrase .= 'Removed settings.<br /><br />';

			$db->query_write("
				DELETE FROM " . TABLE_PREFIX . "datastore
				WHERE title IN(
					'adv_portal_opts',
					'adv_modules',
					'adv_portal_page',
					'adv_portal_pars',
					'adv_portal_stat',
					'adv_portal_home',
					'adv_portal_cale'
			)");

			vBulletinHook::build_datastore($db);

			$stepphrase .= 'Removed fields from the datastore table.<br />';

		break;

		case 4:
			$stepphrase = 'Removed index added on user table.<br />';
			vbflush();
			$db->query_write("ALTER TABLE" . TABLE_PREFIX . "user DROP INDEX (posts)");
		break;

		case 5:
			$stepphrase = 'Removed index added on poll table.<br />';
			vbflush();
			$db->query_write("ALTER TABLE" . TABLE_PREFIX . "poll DROP INDEX (dateline)");
		break;

		case 6:
			$stepphrase = 'Removed index added on thread table.<br />';
			vbflush();
			$db->query_write("ALTER TABLE" . TABLE_PREFIX . "thread DROP INDEX (lastpost)");
		break;

		case 7:
			$stepphrase = 'Removed index added on post table.<br />';
			vbflush();
			$db->query_write("ALTER TABLE" . TABLE_PREFIX . "post DROP INDEX (dateline)");
			$nextstep = 'finished';

			if ($forumsoff)
			{
				$db->query_write("UPDATE " . TABLE_PREFIX . "setting SET value = 1 WHERE varname = 'bbactive'");
				build_options();

				$stepphrase .= '<br />Your forums have now been turned back on.';
			}
		break;

		case 'finished':

			$stepphrase = 'vBadvanced ' . $scriptname . ' Successfully Uninstalled.<br /> <br /><a href="index.php"><strong>Log Into Admin CP --&gt;</strong></a><br /><br /><a href="' . $scriptfile . '.php"><strong>Click here to re-install --&gt;</strong></a>';
			$nocontinue = 1;

		break;
	}

	print_install_table_end();
}

// ##### Rebuild Settings #####################################################
if ($_REQUEST['do'] == 'rebuildsettings')
{
	print_install_table_start();

	rebuild_all_settings();

	$stepphrase = 'Settings rebuilt.<br /><br />';
	$nextdo = 'finished';

	print_install_table_end();
}

// ##### Reinstall plugins ####################################################
if ($_REQUEST['do'] == 'updateplugins')
{
	print_install_table_start();

	insert_plugins();

	$stepphrase = 'Plugins reinstalled.<br /><br />';
	$nextdo = 'finished';

	print_install_table_end();
}

print_cp_footer();

?>